/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.sun.http;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpsServer;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;
import org.jboss.resteasy.core.Headers;
import org.jboss.resteasy.specimpl.HttpHeadersImpl;
import org.jboss.resteasy.spi.ResteasyUriInfo;
import org.jboss.resteasy.util.MediaTypeHelper;
import org.jboss.resteasy.util.PathHelper;

public class HttpExchangeUtil {
    public static ResteasyUriInfo extractUriInfo(HttpExchange exchange) {
        String host = exchange.getLocalAddress().getHostName();
        if (exchange.getLocalAddress().getPort() != 80 && exchange.getLocalAddress().getPort() != 443) {
            host = host + ":" + exchange.getLocalAddress().getPort();
        }
        String uri = exchange.getRequestURI().toString();
        String protocol = exchange.getHttpContext().getServer() instanceof HttpsServer ? "https" : "http";
        URI absoluteURI = URI.create(protocol + "://" + host + uri);
        String contextPath = exchange.getHttpContext().getPath();
        String path = PathHelper.getEncodedPathInfo((String)absoluteURI.getRawPath(), (String)contextPath);
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        URI baseURI = absoluteURI;
        if (!path.trim().equals("")) {
            String tmpContextPath = contextPath;
            if (!tmpContextPath.endsWith("/")) {
                tmpContextPath = tmpContextPath + "/";
            }
            baseURI = UriBuilder.fromUri((URI)absoluteURI).replacePath(tmpContextPath).replaceQuery(null).build(new Object[0]);
        } else {
            baseURI = UriBuilder.fromUri((URI)absoluteURI).replaceQuery(null).build(new Object[0]);
        }
        URI relativeURI = UriBuilder.fromUri((String)path).replaceQuery(absoluteURI.getRawQuery()).build(new Object[0]);
        ResteasyUriInfo uriInfo = new ResteasyUriInfo(baseURI, relativeURI);
        return uriInfo;
    }

    public static HttpHeaders extractHttpHeaders(HttpExchange request) {
        HttpHeadersImpl headers = new HttpHeadersImpl();
        MultivaluedMap<String, String> requestHeaders = HttpExchangeUtil.extractRequestHeaders(request);
        headers.setRequestHeaders(requestHeaders);
        List<MediaType> acceptableMediaTypes = HttpExchangeUtil.extractAccepts(requestHeaders);
        List<String> acceptableLanguages = HttpExchangeUtil.extractLanguages(requestHeaders);
        headers.setAcceptableMediaTypes(acceptableMediaTypes);
        headers.setAcceptableLanguages(acceptableLanguages);
        headers.setLanguage((String)requestHeaders.getFirst((Object)"Content-Language"));
        String contentType = (String)requestHeaders.getFirst((Object)"Content-Type");
        if (contentType != null) {
            headers.setMediaType(MediaType.valueOf((String)contentType));
        }
        Map<String, Cookie> cookies = HttpExchangeUtil.extractCookies(requestHeaders);
        headers.setCookies(cookies);
        return headers;
    }

    static Map<String, Cookie> extractCookies(MultivaluedMap<String, String> headers) {
        HashMap<String, Cookie> cookies = new HashMap<String, Cookie>();
        List cookieHeaders = (List)headers.get((Object)"Cookie");
        if (cookieHeaders == null) {
            return cookies;
        }
        for (String cookieVal : cookieHeaders) {
            Cookie cookie = Cookie.valueOf((String)cookieVal);
            cookies.put(cookie.getName(), cookie);
        }
        return cookies;
    }

    public static List<MediaType> extractAccepts(MultivaluedMap<String, String> requestHeaders) {
        ArrayList<MediaType> acceptableMediaTypes = new ArrayList<MediaType>();
        List accepts = (List)requestHeaders.get((Object)"Accept");
        if (accepts == null) {
            return acceptableMediaTypes;
        }
        for (String accept : accepts) {
            acceptableMediaTypes.addAll(MediaTypeHelper.parseHeader((String)accept));
        }
        return acceptableMediaTypes;
    }

    public static List<String> extractLanguages(MultivaluedMap<String, String> requestHeaders) {
        ArrayList<String> acceptable = new ArrayList<String>();
        List accepts = (List)requestHeaders.get((Object)"Accept-Language");
        if (accepts == null) {
            return acceptable;
        }
        for (String accept : accepts) {
            String[] splits;
            for (String split : splits = accept.split(",")) {
                acceptable.add(split.trim());
            }
        }
        return acceptable;
    }

    public static MultivaluedMap<String, String> extractRequestHeaders(HttpExchange request) {
        Headers requestHeaders = new Headers();
        for (Map.Entry<String, List<String>> header : request.getRequestHeaders().entrySet()) {
            for (String val : header.getValue()) {
                requestHeaders.add(header.getKey(), (Object)val);
            }
        }
        return requestHeaders;
    }
}

