/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.sun.http;

import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.jboss.resteasy.plugins.server.embedded.EmbeddedJaxrsServer;
import org.jboss.resteasy.plugins.server.embedded.SecurityDomain;
import org.jboss.resteasy.plugins.server.sun.http.HttpContextBuilder;
import org.jboss.resteasy.spi.ResteasyDeployment;

public class SunHttpJaxrsServer
implements EmbeddedJaxrsServer {
    protected HttpContextBuilder context = new HttpContextBuilder();
    protected HttpServer httpServer;
    protected int configuredPort = 8080;
    protected int runtimePort = -1;

    public void setRootResourcePath(String rootResourcePath) {
        this.context.setPath(rootResourcePath);
    }

    public ResteasyDeployment getDeployment() {
        return this.context.getDeployment();
    }

    public void setDeployment(ResteasyDeployment deployment) {
        this.context.setDeployment(deployment);
    }

    public void setSecurityDomain(SecurityDomain securityDomain) {
        this.context.setSecurityDomain(securityDomain);
    }

    public void setHttpServer(HttpServer httpServer) {
        this.httpServer = httpServer;
    }

    public void setPort(int port) {
        this.configuredPort = port;
    }

    public int getPort() {
        return this.runtimePort > 0 ? this.runtimePort : this.configuredPort;
    }

    public void start() {
        if (this.httpServer == null) {
            try {
                this.httpServer = HttpServer.create(new InetSocketAddress(this.configuredPort), 10);
                this.runtimePort = this.httpServer.getAddress().getPort();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.context.bind(this.httpServer);
        this.httpServer.start();
    }

    public void stop() {
        this.runtimePort = -1;
        this.httpServer.stop(10);
        this.context.cleanup();
    }
}

