/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.keystone.as7;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.client.WebTarget;
import org.apache.catalina.connector.Request;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.jboss.resteasy.keystone.as7.JBossWebAuthLoginModule;
import org.jboss.resteasy.keystone.as7.i18n.Messages;
import org.jboss.resteasy.keystone.client.SkeletonKeyAdminClient;
import org.jboss.resteasy.keystone.client.SkeletonKeyClientBuilder;
import org.jboss.resteasy.keystone.core.UserPrincipal;
import org.jboss.resteasy.keystone.model.Access;
import org.jboss.resteasy.keystone.model.Role;
import org.jboss.resteasy.plugins.providers.RegisterBuiltin;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.security.SimpleGroup;
import org.jboss.security.SimplePrincipal;

public class SkeletonKeyStoneLoginModule
extends JBossWebAuthLoginModule {
    static ResteasyClient client;
    static volatile SkeletonKeyAdminClient admin;
    protected String projectId;
    protected Access access;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void initAdmin(Map<String, ?> options) {
        SkeletonKeyAdminClient tmp = admin;
        if (tmp == null) {
            ResteasyClient resteasyClient = client;
            synchronized (resteasyClient) {
                tmp = admin;
                if (tmp == null) {
                    String adminUrl = (String)options.get("skeleton.key.url");
                    String username = (String)options.get("admin.username");
                    String password = (String)options.get("admin.password");
                    ResteasyWebTarget adminTarget = client.target(adminUrl);
                    tmp = admin = new SkeletonKeyClientBuilder().username(username).password(password).idp((WebTarget)adminTarget).admin();
                }
            }
        }
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        SkeletonKeyStoneLoginModule.initAdmin(options);
        this.projectId = (String)options.get("projectId");
    }

    @Override
    protected boolean login(Request request, HttpServletResponse response) throws LoginException {
        String tokenHeader = request.getHeader("X-Auth-Token");
        if (tokenHeader == null) {
            return false;
        }
        this.access = admin.tokens().get(tokenHeader);
        if (this.access.getToken().expired()) {
            throw new LoginException(Messages.MESSAGES.tokenExpired());
        }
        if (!this.projectId.equals(this.access.getToken().getProject().getId())) {
            throw new LoginException(Messages.MESSAGES.tokenProjectIdDoesntMatch());
        }
        this.loginOk = true;
        return true;
    }

    protected Principal getIdentity() {
        UserPrincipal principal = new UserPrincipal(this.access.getUser());
        return principal;
    }

    protected Group[] getRoleSets() throws LoginException {
        SimpleGroup roles = new SimpleGroup("Roles");
        Group[] roleSets = new Group[]{roles};
        for (Role role : this.access.getUser().getRoles()) {
            roles.addMember((Principal)new SimplePrincipal(role.getName()));
        }
        return roleSets;
    }

    static {
        ResteasyProviderFactory providerFactory = new ResteasyProviderFactory();
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(SkeletonKeyStoneLoginModule.class.getClassLoader());
        try {
            RegisterBuiltin.register((ResteasyProviderFactory)providerFactory);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
        client = new ResteasyClientBuilder().providerFactory(providerFactory).connectionPoolSize(100).maxPooledPerRoute(100).build();
    }
}

