/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.multipart;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Providers;
import org.jboss.resteasy.plugins.providers.multipart.InputPart;
import org.jboss.resteasy.plugins.providers.multipart.MultipartInput;
import org.jboss.resteasy.util.CaseInsensitiveMap;
import org.jboss.resteasy.util.GenericType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipartInputImpl
implements MultipartInput {
    protected String boundary;
    protected byte[] boundaryBytes;
    protected int pointer;
    protected List<InputPart> parts = new ArrayList<InputPart>();
    protected PartImpl currPart;
    protected int preambleEnd;
    protected Providers workers;
    protected static final Annotation[] empty = new Annotation[0];
    protected ByteArrayOutputStream baos = new ByteArrayOutputStream();
    protected byte[] buffer;

    public MultipartInputImpl(String boundary, Providers workers) {
        this.boundary = "--" + boundary;
        this.boundaryBytes = this.boundary.getBytes();
        this.workers = workers;
    }

    @Override
    public List<InputPart> getParts() {
        return this.parts;
    }

    protected PartImpl createPart() {
        return new PartImpl();
    }

    public void parse(InputStream is) throws IOException {
        int index = 0;
        while (true) {
            int b;
            if ((b = this.read(is)) == this.boundaryBytes[index]) {
                if (++index != this.boundaryBytes.length) continue;
                int b1 = this.read(is);
                if (b1 == -1) {
                    throw new RuntimeException("Unexpected end of request, read bounder then EOF");
                }
                int b2 = this.read(is);
                if (b2 == -1) {
                    throw new RuntimeException("Unexpected end of request, read bounder then EOF");
                }
                if (b1 == 13 && b2 == 10) {
                    if (this.currPart != null) {
                        this.currPart.endBody(this.pointer - 4 - this.boundaryBytes.length);
                    } else {
                        this.preambleEnd = this.pointer - 4 - this.boundaryBytes.length;
                    }
                } else {
                    if (b1 == 45 && b2 == 45) {
                        if (this.currPart != null) {
                            this.currPart.endBody(this.pointer - 4 - this.boundaryBytes.length);
                            break;
                        }
                        this.preambleEnd = this.pointer - 4 - this.boundaryBytes.length;
                        break;
                    }
                    throw new RuntimeException("Found boundary but no trailing \\r\\n or --");
                }
                this.currPart = this.createPart();
                this.extractPart(is);
                index = 0;
                continue;
            }
            index = 0;
        }
        this.buffer = this.baos.toByteArray();
    }

    protected void extractPart(InputStream is) throws IOException {
        this.parts.add(this.currPart);
        String line = null;
        do {
            if ("".equals(line = this.readLine(is))) continue;
            this.currPart.addHeader(line);
        } while (line.length() > 0);
        this.currPart.startBody(this.pointer);
    }

    @Override
    public String getPreamble() {
        if (this.preambleEnd < 0) {
            return null;
        }
        return new String(this.buffer, 0, this.preambleEnd);
    }

    public String getBufferAsString() {
        return new String(this.buffer);
    }

    protected String readLine(InputStream is) throws IOException {
        StringBuffer buf = new StringBuffer();
        while (true) {
            int b;
            if ((b = this.read(is)) == -1) {
                throw new RuntimeException("Unexpected end of buffer");
            }
            if (b == 13) {
                b = this.read(is);
                if (b == 10) {
                    return buf.toString();
                }
                buf.append('\r').append((char)b);
                continue;
            }
            buf.append((char)b);
        }
    }

    protected int read(InputStream is) throws IOException {
        int b = is.read();
        if (b == -1) {
            return -1;
        }
        this.baos.write(b);
        ++this.pointer;
        return b;
    }

    public static void main(String[] args) throws Exception {
        String input = "URLSTR: file:/Users/billburke/jboss/resteasy-jaxrs/resteasy-jaxrs/src/test/test-data/data.txt\r\n--B98hgCmKsQ-B5AUFnm2FnDRCgHPDE3\r\nContent-Disposition: form-data; name=\"part1\"\r\nContent-Type: text/plain; charset=US-ASCII\r\nContent-Transfer-Encoding: 8bit\r\n\r\nThis is Value 1\r\n--B98hgCmKsQ-B5AUFnm2FnDRCgHPDE3\r\nContent-Disposition: form-data; name=\"part2\"\r\nContent-Type: text/plain; charset=US-ASCII\r\nContent-Transfer-Encoding: 8bit\r\n\r\nThis is Value 2\r\n--B98hgCmKsQ-B5AUFnm2FnDRCgHPDE3\r\nContent-Disposition: form-data; name=\"data.txt\"; filename=\"data.txt\"\r\nContent-Type: application/octet-stream; charset=ISO-8859-1\r\nContent-Transfer-Encoding: binary\r\n\r\nhello world\r\n--B98hgCmKsQ-B5AUFnm2FnDRCgHPDE3--";
        ByteArrayInputStream bais = new ByteArrayInputStream(input.getBytes());
        MultipartInputImpl multipart = new MultipartInputImpl("B98hgCmKsQ-B5AUFnm2FnDRCgHPDE3", null);
        multipart.parse(bais);
        System.out.println(multipart.getPreamble());
        System.out.println("**********");
        for (InputPart part : multipart.getParts()) {
            System.out.println("--");
            System.out.println("\"" + part.getBodyAsString() + "\"");
        }
        System.out.println("done");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PartImpl
    implements InputPart {
        private int start;
        private int end;
        private MultivaluedMap<String, String> headers = new CaseInsensitiveMap();
        private MediaType mediaType;

        @Override
        public MultivaluedMap<String, String> getHeaders() {
            return this.headers;
        }

        public void startBody(int index) {
            this.start = index;
        }

        public void endBody(int index) {
            this.end = index;
            String mime = (String)this.headers.getFirst((Object)"content-type");
            this.mediaType = mime == null ? MediaType.TEXT_PLAIN_TYPE : MediaType.valueOf((String)mime);
        }

        public void addHeader(String header) {
            int colon = header.indexOf(58);
            String name = header.substring(0, colon);
            String value = header.substring(colon + 1);
            if (value.charAt(0) == '\"') {
                value = value.substring(1);
            }
            if (value.endsWith("\"")) {
                value = value.substring(0, value.length() - 1);
            }
            this.headers.add((Object)name.trim(), (Object)value.trim());
        }

        public InputStream getBody() {
            return new ByteArrayInputStream(MultipartInputImpl.this.buffer, this.start, this.end - this.start);
        }

        @Override
        public String getBodyAsString() {
            return new String(MultipartInputImpl.this.buffer, this.start, this.end - this.start);
        }

        @Override
        public <T> T getBody(Class<T> type, Type genericType) throws IOException {
            MessageBodyReader reader = MultipartInputImpl.this.workers.getMessageBodyReader(type, genericType, empty, this.mediaType);
            return (T)reader.readFrom(type, genericType, empty, this.mediaType, this.headers, this.getBody());
        }

        @Override
        public <T> T getBody(GenericType<T> type) throws IOException {
            return this.getBody(type.getType(), type.getGenericType());
        }

        @Override
        public MediaType getMediaType() {
            return this.mediaType;
        }
    }
}

