/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.multipart;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.ext.Providers;
import org.jboss.resteasy.plugins.providers.multipart.InputPart;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataInput;
import org.jboss.resteasy.plugins.providers.multipart.MultipartInputImpl;
import org.jboss.resteasy.util.GenericType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipartFormDataInputImpl
extends MultipartInputImpl
implements MultipartFormDataInput {
    protected Map<String, InputPart> formData = new HashMap<String, InputPart>();
    protected static final Pattern DISPOSITION = Pattern.compile(";\\s*name=\"?([^\";]*)\"?");

    public MultipartFormDataInputImpl(String boundary, Providers workers) {
        super(boundary, workers);
    }

    @Override
    public Map<String, InputPart> getFormData() {
        return this.formData;
    }

    @Override
    public <T> T getFormDataPart(String key, Class<T> rawType, Type genericType) throws IOException {
        InputPart part = this.getFormData().get(key);
        if (part == null) {
            return null;
        }
        return part.getBody(rawType, genericType);
    }

    @Override
    public <T> T getFormDataPart(String key, GenericType<T> type) throws IOException {
        InputPart part = this.getFormData().get(key);
        if (part == null) {
            return null;
        }
        return part.getBody(type);
    }

    @Override
    protected void extractPart(InputStream is) throws IOException {
        super.extractPart(is);
        String disposition = (String)this.currPart.getHeaders().getFirst((Object)"Content-Disposition");
        if (disposition == null) {
            throw new RuntimeException("Could find no Content-Disposition header within part");
        }
        Matcher matcher = DISPOSITION.matcher(disposition);
        if (!matcher.find()) {
            throw new RuntimeException("Could not parse Content-Disposition for MultipartFormData: " + disposition);
        }
        this.formData.put(matcher.group(1).trim(), this.currPart);
    }
}

