/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.multipart;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;
import org.jboss.resteasy.plugins.providers.multipart.InputPart;
import org.jboss.resteasy.plugins.providers.multipart.MultipartInputImpl;
import org.jboss.resteasy.util.Types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Consumes(value={"multipart/*"})
public class ListMultipartReader
implements MessageBodyReader<List<?>> {
    @Context
    protected Providers workers;

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type.equals(List.class) && genericType != null && genericType instanceof ParameterizedType;
    }

    public List<?> readFrom(Class<List<?>> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        String boundary = (String)mediaType.getParameters().get("boundary");
        if (boundary == null) {
            throw new IOException("Unable to get boundary for multipart");
        }
        ParameterizedType param = (ParameterizedType)genericType;
        Type baseType = param.getActualTypeArguments()[0];
        Class rawType = Types.getRawType((Type)baseType);
        MultipartInputImpl input = new MultipartInputImpl(mediaType, this.workers);
        input.parse(entityStream);
        ArrayList list = new ArrayList();
        for (InputPart part : input.getParts()) {
            list.add(part.getBody(rawType, baseType));
        }
        return list;
    }
}

