/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.netty;

import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import java.security.Principal;
import java.util.Base64;
import java.util.List;
import javax.ws.rs.core.SecurityContext;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.core.ThreadLocalResteasyProviderFactory;
import org.jboss.resteasy.plugins.server.embedded.SecurityDomain;
import org.jboss.resteasy.plugins.server.netty.NettySecurityContext;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class RequestDispatcher {
    protected final SynchronousDispatcher dispatcher;
    protected final ResteasyProviderFactory providerFactory;
    protected final SecurityDomain domain;

    public RequestDispatcher(SynchronousDispatcher dispatcher, ResteasyProviderFactory providerFactory, SecurityDomain domain) {
        this.dispatcher = dispatcher;
        this.providerFactory = providerFactory;
        this.domain = domain;
    }

    public SynchronousDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public SecurityDomain getDomain() {
        return this.domain;
    }

    public ResteasyProviderFactory getProviderFactory() {
        return this.providerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(ChannelHandlerContext ctx, HttpRequest request, HttpResponse response, boolean handleNotFound) throws IOException {
        try {
            SecurityContext securityContext;
            ResteasyProviderFactory defaultInstance = ResteasyProviderFactory.getInstance();
            if (defaultInstance instanceof ThreadLocalResteasyProviderFactory) {
                ThreadLocalResteasyProviderFactory.push((ResteasyProviderFactory)this.providerFactory);
            }
            if (this.domain != null) {
                securityContext = this.basicAuthentication(request, response);
                if (securityContext == null) {
                    return;
                }
            } else {
                securityContext = new NettySecurityContext();
            }
            try {
                ResteasyContext.pushContext(SecurityContext.class, (Object)securityContext);
                ResteasyContext.pushContext(ChannelHandlerContext.class, (Object)ctx);
                if (handleNotFound) {
                    this.dispatcher.invoke(request, response);
                } else {
                    this.dispatcher.invokePropagateNotFound(request, response);
                }
            }
            finally {
                ResteasyContext.clearContextData();
            }
        }
        finally {
            ResteasyProviderFactory defaultInstance = ResteasyProviderFactory.getInstance();
            if (defaultInstance instanceof ThreadLocalResteasyProviderFactory) {
                ThreadLocalResteasyProviderFactory.pop();
            }
        }
    }

    private SecurityContext basicAuthentication(HttpRequest request, HttpResponse response) throws IOException {
        String auth;
        List headers = request.getHttpHeaders().getRequestHeader("Authorization");
        if (!headers.isEmpty() && (auth = (String)headers.get(0)).length() > 5) {
            String type = auth.substring(0, 5);
            if ("basic".equals(type = type.toLowerCase())) {
                String cookie = auth.substring(6);
                cookie = new String(Base64.getDecoder().decode(cookie.getBytes()));
                String[] split = cookie.split(":");
                Principal user = null;
                try {
                    user = this.domain.authenticate(split[0], split[1]);
                    return new NettySecurityContext(user, this.domain, "BASIC", true);
                }
                catch (SecurityException e) {
                    response.sendError(401);
                    return null;
                }
            }
            response.sendError(401);
            return null;
        }
        return null;
    }
}

