/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.reactor.netty;

import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.jboss.resteasy.core.AbstractAsynchronousResponse;
import org.jboss.resteasy.core.AbstractExecutionContext;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.plugins.server.BaseHttpRequest;
import org.jboss.resteasy.plugins.server.reactor.netty.NettyUtil;
import org.jboss.resteasy.plugins.server.reactor.netty.ReactorNettyHttpResponse;
import org.jboss.resteasy.plugins.server.reactor.netty.i18n.Messages;
import org.jboss.resteasy.specimpl.ResteasyHttpHeaders;
import org.jboss.resteasy.specimpl.ResteasyUriInfo;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.NotImplementedYetException;
import org.jboss.resteasy.spi.ResteasyAsynchronousContext;
import org.jboss.resteasy.spi.ResteasyAsynchronousResponse;
import org.jboss.resteasy.spi.RunnableWithException;
import org.jboss.resteasy.util.CaseInsensitiveMap;
import reactor.netty.http.server.HttpServerRequest;

class ReactorNettyHttpRequest
extends BaseHttpRequest {
    private static final Logger log = Logger.getLogger(ReactorNettyHttpRequest.class);
    private final HttpServerRequest req;
    private final ResteasyHttpHeaders resteasyHttpHeaders;
    private String httpMethod;
    private InputStream in;
    private final NettyExecutionContext executionContext;
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private Duration timeout;

    ReactorNettyHttpRequest(ResteasyUriInfo uri, HttpServerRequest req, InputStream body, ReactorNettyHttpResponse response, SynchronousDispatcher dispatcher) {
        super(uri);
        this.req = Objects.requireNonNull(req);
        this.in = Objects.requireNonNull(body);
        this.executionContext = new NettyExecutionContext(this, response, dispatcher);
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        req.requestHeaders().forEach(e -> map.putSingle((Object)((String)e.getKey()).toLowerCase(), (Object)((String)e.getValue())));
        this.resteasyHttpHeaders = new ResteasyHttpHeaders((MultivaluedMap)map);
        this.httpMethod = req.method().name();
    }

    public HttpHeaders getHttpHeaders() {
        return this.resteasyHttpHeaders;
    }

    public MultivaluedMap<String, String> getMutableHeaders() {
        return this.resteasyHttpHeaders.getMutableHeaders();
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public void setInputStream(InputStream stream) {
        this.in = stream;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(String method) {
        this.httpMethod = method;
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    public Object getAttribute(String attribute) {
        return this.attributes.get(attribute);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public ResteasyAsynchronousContext getAsyncContext() {
        return this.executionContext;
    }

    public void forward(String path) {
        throw new NotImplementedYetException();
    }

    public boolean wasForwarded() {
        return false;
    }

    public String getRemoteAddress() {
        return this.req.remoteAddress().getAddress().getHostAddress();
    }

    public String getRemoteHost() {
        return this.req.remoteAddress().getHostName();
    }

    Duration timeout() {
        return this.timeout;
    }

    class NettyExecutionContext
    extends AbstractExecutionContext {
        protected final ReactorNettyHttpRequest request;
        protected final ReactorNettyHttpResponse response;
        protected volatile boolean done;
        protected volatile boolean cancelled;
        protected volatile boolean wasSuspended;
        protected NettyHttpAsyncResponse asyncResponse;

        NettyExecutionContext(ReactorNettyHttpRequest request, ReactorNettyHttpResponse response, SynchronousDispatcher dispatcher) {
            super(dispatcher, (HttpRequest)request, (HttpResponse)response);
            this.request = request;
            this.response = response;
            this.asyncResponse = new NettyHttpAsyncResponse(dispatcher, request, response);
        }

        public boolean isSuspended() {
            return this.wasSuspended;
        }

        public ResteasyAsynchronousResponse getAsyncResponse() {
            return this.asyncResponse;
        }

        public ResteasyAsynchronousResponse suspend() throws IllegalStateException {
            return this.suspend(-1L);
        }

        public ResteasyAsynchronousResponse suspend(long millis) throws IllegalStateException {
            return this.suspend(millis, TimeUnit.MILLISECONDS);
        }

        public ResteasyAsynchronousResponse suspend(long time, TimeUnit unit) throws IllegalStateException {
            if (this.wasSuspended) {
                throw new IllegalStateException(Messages.MESSAGES.alreadySuspended());
            }
            this.wasSuspended = true;
            return this.asyncResponse;
        }

        public void complete() {
            if (this.wasSuspended) {
                this.asyncResponse.complete();
            }
        }

        public CompletionStage<Void> executeAsyncIo(CompletionStage<Void> f) {
            CompletableFuture<Void> ret = f.toCompletableFuture();
            if (!ret.isDone() && !this.isSuspended()) {
                this.suspend();
            }
            return ret;
        }

        public CompletionStage<Void> executeBlockingIo(RunnableWithException f, boolean hasInterceptors) {
            if (!NettyUtil.isIoThread()) {
                try {
                    f.run();
                }
                catch (Exception e) {
                    CompletableFuture<Void> ret = new CompletableFuture<Void>();
                    ret.completeExceptionally(e);
                    return ret;
                }
                return CompletableFuture.completedFuture(null);
            }
            if (!hasInterceptors) {
                Map context = ResteasyContext.getContextDataMap();
                if (!this.isSuspended()) {
                    this.suspend();
                }
                return CompletableFuture.runAsync(() -> {
                    try (ResteasyContext.CloseableContext newContext = ResteasyContext.addCloseableContextDataLevel((Map)context);){
                        f.run();
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            CompletableFuture<Void> ret = new CompletableFuture<Void>();
            ret.completeExceptionally(new RuntimeException("Cannot use blocking IO with interceptors when we're on the IO thread"));
            return ret;
        }

        class NettyHttpAsyncResponse
        extends AbstractAsynchronousResponse {
            private final Object responseLock;
            protected ScheduledFuture<?> timeoutFuture;
            private ReactorNettyHttpResponse nettyResponse;

            NettyHttpAsyncResponse(SynchronousDispatcher dispatcher, ReactorNettyHttpRequest request, ReactorNettyHttpResponse response) {
                super(dispatcher, (HttpRequest)request, (HttpResponse)response);
                this.responseLock = new Object();
                this.nettyResponse = response;
            }

            public void initialRequestThreadFinished() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void complete() {
                Object object = this.responseLock;
                synchronized (object) {
                    if (NettyExecutionContext.this.done) {
                        return;
                    }
                    if (NettyExecutionContext.this.cancelled) {
                        return;
                    }
                    NettyExecutionContext.this.done = true;
                    this.nettyFlush();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean resume(Object entity) {
                Object object = this.responseLock;
                synchronized (object) {
                    if (NettyExecutionContext.this.done) {
                        return false;
                    }
                    if (NettyExecutionContext.this.cancelled) {
                        return false;
                    }
                    NettyExecutionContext.this.done = true;
                    return this.internalResume(entity, t -> this.nettyFlush());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean resume(Throwable ex) {
                Object object = this.responseLock;
                synchronized (object) {
                    if (NettyExecutionContext.this.done) {
                        return false;
                    }
                    if (NettyExecutionContext.this.cancelled) {
                        return false;
                    }
                    NettyExecutionContext.this.done = true;
                    return this.internalResume(ex, t -> this.nettyFlush());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean cancel() {
                log.trace((Object)"Cancellation occurred!");
                Object object = this.responseLock;
                synchronized (object) {
                    if (NettyExecutionContext.this.cancelled) {
                        return true;
                    }
                    if (NettyExecutionContext.this.done) {
                        return false;
                    }
                    NettyExecutionContext.this.done = true;
                    NettyExecutionContext.this.cancelled = true;
                    return this.internalResume(Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build(), t -> this.nettyFlush());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean cancel(int retryAfter) {
                log.trace((Object)"Cancellation occurred!");
                Object object = this.responseLock;
                synchronized (object) {
                    if (NettyExecutionContext.this.cancelled) {
                        return true;
                    }
                    if (NettyExecutionContext.this.done) {
                        return false;
                    }
                    NettyExecutionContext.this.done = true;
                    NettyExecutionContext.this.cancelled = true;
                    return this.internalResume(Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).header("Retry-After", (Object)retryAfter).build(), t -> this.nettyFlush());
                }
            }

            protected synchronized void nettyFlush() {
                try {
                    this.nettyResponse.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean cancel(Date retryAfter) {
                log.trace((Object)"Cancellation occurred!");
                Object object = this.responseLock;
                synchronized (object) {
                    if (NettyExecutionContext.this.cancelled) {
                        return true;
                    }
                    if (NettyExecutionContext.this.done) {
                        return false;
                    }
                    NettyExecutionContext.this.done = true;
                    NettyExecutionContext.this.cancelled = true;
                    return this.internalResume(Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).header("Retry-After", (Object)retryAfter).build(), t -> this.nettyFlush());
                }
            }

            public boolean isSuspended() {
                return !NettyExecutionContext.this.done && !NettyExecutionContext.this.cancelled;
            }

            public boolean isCancelled() {
                return NettyExecutionContext.this.cancelled;
            }

            public boolean isDone() {
                return NettyExecutionContext.this.done;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean setTimeout(long time, TimeUnit unit) {
                log.debug((Object)"Setting timeout");
                Object object = this.responseLock;
                synchronized (object) {
                    if (NettyExecutionContext.this.done || NettyExecutionContext.this.cancelled) {
                        return false;
                    }
                    if (this.timeoutFuture != null && !this.timeoutFuture.cancel(false)) {
                        return false;
                    }
                    ReactorNettyHttpRequest.this.timeout = Duration.ofNanos(unit.toNanos(time));
                }
                return true;
            }
        }
    }
}

