/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.rxjava2.propagation;

import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.BiFunction;
import java.util.concurrent.Executor;
import org.jboss.resteasy.concurrent.ContextualExecutors;

class ContextPropagatorOnCompletableCreateAction
implements BiFunction<Completable, CompletableObserver, CompletableObserver> {
    ContextPropagatorOnCompletableCreateAction() {
    }

    public CompletableObserver apply(Completable completable, CompletableObserver observer) throws Exception {
        return new ContextCapturerCompletable(completable, observer, ContextualExecutors.executor());
    }

    private static class ContextCapturerCompletable
    implements CompletableObserver {
        private final CompletableObserver source;
        private final Executor contextExecutor;

        private ContextCapturerCompletable(Completable s, CompletableObserver o, Executor contextExecutor) {
            this.source = o;
            this.contextExecutor = contextExecutor;
        }

        public void onError(Throwable t) {
            this.contextExecutor.execute(() -> this.source.onError(t));
        }

        public void onSubscribe(Disposable d) {
            this.contextExecutor.execute(() -> this.source.onSubscribe(d));
        }

        public void onComplete() {
            this.contextExecutor.execute(() -> ((CompletableObserver)this.source).onComplete());
        }
    }
}

