/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.springboot;

import java.util.Set;
import javax.servlet.Servlet;
import org.jboss.resteasy.plugins.server.servlet.HttpServlet30Dispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.servlet.ServletRegistrationBean;

public class ResteasyApplicationBuilder {
    public static final String BEAN_NAME = "JaxrsApplicationServletBuilder";
    private static final Logger logger = LoggerFactory.getLogger(ResteasyApplicationBuilder.class);

    public ServletRegistrationBean build(String applicationClassName, String path, Set<Class<?>> resources, Set<Class<?>> providers) {
        StringBuilder builder;
        HttpServlet30Dispatcher servlet = new HttpServlet30Dispatcher();
        ServletRegistrationBean servletRegistrationBean = new ServletRegistrationBean((Servlet)servlet, new String[0]);
        servletRegistrationBean.setName(applicationClassName);
        servletRegistrationBean.setLoadOnStartup(1);
        servletRegistrationBean.setAsyncSupported(true);
        servletRegistrationBean.addInitParameter("javax.ws.rs.Application", applicationClassName);
        if (path != null) {
            String prefix;
            String mapping = path;
            if (!mapping.startsWith("/")) {
                mapping = "/" + mapping;
            }
            if (!"/".equals(prefix = mapping) && prefix.endsWith("/")) {
                prefix = prefix.substring(0, prefix.length() - 1);
            }
            mapping = mapping.endsWith("/") ? mapping + "*" : mapping + "/*";
            servletRegistrationBean.addInitParameter("resteasy.servlet.mapping.prefix", prefix);
            servletRegistrationBean.addUrlMappings(new String[]{mapping});
        }
        if (resources.size() > 0) {
            builder = new StringBuilder();
            boolean first = true;
            for (Class<?> resource : resources) {
                if (first) {
                    first = false;
                } else {
                    builder.append(",");
                }
                builder.append(resource.getName());
            }
            servletRegistrationBean.addInitParameter("resteasy.scanned.resources", builder.toString());
        }
        if (providers.size() > 0) {
            builder = new StringBuilder();
            boolean first = true;
            for (Class<?> provider : providers) {
                if (first) {
                    first = false;
                } else {
                    builder.append(",");
                }
                builder.append(provider.getName());
            }
            servletRegistrationBean.addInitParameter("resteasy.scanned.providers", builder.toString());
        }
        logger.debug("ServletRegistrationBean has just bean created for JAX-RS class " + applicationClassName);
        return servletRegistrationBean;
    }
}

