/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.springboot;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.springboot.JaxrsApplicationScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.ConfigurableEnvironment;

public class ResteasyEmbeddedServletInitializer
implements BeanFactoryPostProcessor {
    private static final String JAXRS_APP_CLASSES_DEFINITION_PROPERTY = "resteasy.jaxrs.app.registration";
    private static final String JAXRS_APP_CLASSES_PROPERTY = "resteasy.jaxrs.app.classes";
    private static final String JAXRS_DEFAULT_PATH = "resteasy.jaxrs.defaultPath";
    private static final String SERVLET_MAPPING_PREFIX = "resteasy.servlet.mapping.prefix";
    private Set<Class<? extends Application>> applications = new HashSet<Class<? extends Application>>();
    private Set<Class<?>> allResources = new HashSet();
    private Set<Class<?>> providers = new HashSet();
    private static final Logger logger = LoggerFactory.getLogger(ResteasyEmbeddedServletInitializer.class);

    private void findJaxrsApplications(ConfigurableListableBeanFactory beanFactory) {
        logger.info("Finding JAX-RS Application classes");
        JaxrsAppClassesRegistration registration = this.getJaxrsAppClassesRegistration(beanFactory);
        switch (registration) {
            case AUTO: {
                this.findJaxrsApplicationBeans(beanFactory);
                if (this.applications.size() == 0) {
                    this.findJaxrsApplicationProperty(beanFactory);
                }
                if (this.applications.size() != 0) break;
                this.findJaxrsApplicationScanning((BeanFactory)beanFactory);
                break;
            }
            case BEANS: {
                this.findJaxrsApplicationBeans(beanFactory);
                break;
            }
            case PROPERTY: {
                this.findJaxrsApplicationProperty(beanFactory);
                break;
            }
            case SCANNING: {
                this.findJaxrsApplicationScanning((BeanFactory)beanFactory);
                break;
            }
            default: {
                logger.error("JAX-RS application registration method (%s) not known, no application will be registered", (Object)registration.name());
            }
        }
        for (Object appClass : this.applications.toArray()) {
            logger.info("JAX-RS Application class found: {}", (Object)((Class)appClass).getName());
        }
    }

    private JaxrsAppClassesRegistration getJaxrsAppClassesRegistration(ConfigurableListableBeanFactory beanFactory) {
        ConfigurableEnvironment configurableEnvironment = (ConfigurableEnvironment)beanFactory.getBean(ConfigurableEnvironment.class);
        String jaxrsAppClassesRegistration = configurableEnvironment.getProperty(JAXRS_APP_CLASSES_DEFINITION_PROPERTY);
        JaxrsAppClassesRegistration registration = JaxrsAppClassesRegistration.AUTO;
        if (jaxrsAppClassesRegistration == null) {
            logger.info("Property {} has not been set, JAX-RS Application classes registration is being set to AUTO", (Object)JAXRS_APP_CLASSES_DEFINITION_PROPERTY);
        } else {
            logger.info("Property {} has been set to {}", (Object)JAXRS_APP_CLASSES_DEFINITION_PROPERTY, (Object)jaxrsAppClassesRegistration);
            try {
                registration = JaxrsAppClassesRegistration.valueOf(jaxrsAppClassesRegistration.toUpperCase());
            }
            catch (IllegalArgumentException ex) {
                String errorMesage = String.format("Property %s has not been properly set, value %s is invalid. JAX-RS Application classes registration is being set to AUTO.", JAXRS_APP_CLASSES_DEFINITION_PROPERTY, jaxrsAppClassesRegistration);
                logger.error(errorMesage);
                throw new IllegalArgumentException(errorMesage, ex);
            }
        }
        return registration;
    }

    private void findJaxrsApplicationBeans(ConfigurableListableBeanFactory beanFactory) {
        logger.info("Searching for JAX-RS Application Spring beans");
        Map applicationBeans = beanFactory.getBeansOfType(Application.class, true, false);
        if (applicationBeans == null || applicationBeans.size() == 0) {
            logger.info("No JAX-RS Application Spring beans found");
            return;
        }
        for (Application application : applicationBeans.values()) {
            this.applications.add(application.getClass());
        }
    }

    private void findJaxrsApplicationProperty(ConfigurableListableBeanFactory beanFactory) {
        String[] jaxrsClassNames;
        ConfigurableEnvironment configurableEnvironment = (ConfigurableEnvironment)beanFactory.getBean(ConfigurableEnvironment.class);
        String jaxrsAppsProperty = configurableEnvironment.getProperty(JAXRS_APP_CLASSES_PROPERTY);
        if (jaxrsAppsProperty == null) {
            logger.info("No JAX-RS Application set via property {}", (Object)JAXRS_APP_CLASSES_PROPERTY);
            return;
        }
        logger.info("Property {} has been set to {}", (Object)JAXRS_APP_CLASSES_PROPERTY, (Object)jaxrsAppsProperty);
        for (String jaxrsClassName : jaxrsClassNames = jaxrsAppsProperty.split(",")) {
            Class<?> jaxrsClass = null;
            try {
                jaxrsClass = Class.forName(jaxrsClassName.trim());
            }
            catch (ClassNotFoundException e) {
                String exceptionMessage = String.format("JAX-RS Application class %s has not been found", jaxrsClassName.trim());
                logger.error(exceptionMessage, (Throwable)e);
                throw new BeansException(exceptionMessage, e){};
            }
            this.applications.add(jaxrsClass);
        }
    }

    private void findJaxrsApplicationScanning(BeanFactory beanFactory) {
        List<String> packagesToBeScanned = this.getSpringApplicationPackages(beanFactory);
        Set<Class<? extends Application>> applications = JaxrsApplicationScanner.getApplications(packagesToBeScanned);
        if (applications == null || applications.size() == 0) {
            return;
        }
        this.applications.addAll(applications);
    }

    private List<String> getSpringApplicationPackages(BeanFactory beanFactory) {
        return AutoConfigurationPackages.get((BeanFactory)beanFactory);
    }

    private void findJaxrsResourcesAndProviderClasses(ConfigurableListableBeanFactory beanFactory) {
        logger.debug("Finding JAX-RS resources and providers Spring bean classes");
        String[] resourceBeans = beanFactory.getBeanNamesForAnnotation(Path.class);
        String[] providerBeans = beanFactory.getBeanNamesForAnnotation(Provider.class);
        if (resourceBeans != null) {
            for (String resourceBean : resourceBeans) {
                this.allResources.add(beanFactory.getType(resourceBean));
            }
        }
        if (providerBeans != null) {
            for (String providerBean : providerBeans) {
                this.providers.add(beanFactory.getType(providerBean));
            }
        }
        if (logger.isDebugEnabled()) {
            for (Object resourceClass : this.allResources.toArray()) {
                logger.debug("JAX-RS resource class found: {}", (Object)((Class)resourceClass).getName());
            }
        }
        if (logger.isDebugEnabled()) {
            for (Object providerClass : this.providers.toArray()) {
                logger.debug("JAX-RS provider class found: {}", (Object)((Class)providerClass).getName());
            }
        }
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        logger.debug("Post process bean factory has been called");
        this.findJaxrsApplications(beanFactory);
        this.findJaxrsResourcesAndProviderClasses(beanFactory);
        if (this.allResources.size() == 0) {
            logger.warn("No JAX-RS resource Spring beans have been found");
        }
        if (this.applications.size() == 0) {
            this.registerDefaultJaxrsApp(beanFactory);
            return;
        }
        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
        ConfigurableEnvironment configurableEnvironment = (ConfigurableEnvironment)beanFactory.getBean(ConfigurableEnvironment.class);
        String servletMappingPrefix = configurableEnvironment.getProperty(SERVLET_MAPPING_PREFIX);
        if (servletMappingPrefix != null) {
            logger.info("resteasy.servlet.mapping.prefix specified. JAX-RS Applications will be mapped to {}", (Object)servletMappingPrefix);
        }
        for (Class<? extends Application> applicationClass : this.applications) {
            ApplicationPath path = (ApplicationPath)AnnotationUtils.findAnnotation(applicationClass, ApplicationPath.class);
            if (path == null && servletMappingPrefix == null) {
                logger.warn("JAX-RS Application class {} has no ApplicationPath annotation, so it will not be registered", (Object)applicationClass.getName());
                continue;
            }
            logger.debug("registering JAX-RS application class " + applicationClass.getName());
            String effectivePath = servletMappingPrefix != null ? servletMappingPrefix : path.value();
            GenericBeanDefinition applicationServletBean = this.createApplicationServlet(applicationClass, effectivePath);
            registry.registerBeanDefinition(applicationClass.getName(), (BeanDefinition)applicationServletBean);
        }
    }

    private void registerDefaultJaxrsApp(ConfigurableListableBeanFactory beanFactory) {
        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
        ConfigurableEnvironment configurableEnvironment = (ConfigurableEnvironment)beanFactory.getBean(ConfigurableEnvironment.class);
        String path = configurableEnvironment.getProperty(JAXRS_DEFAULT_PATH, "/");
        GenericBeanDefinition applicationServletBean = this.createApplicationServlet(Application.class, path);
        logger.info("No JAX-RS Application classes have been found. A default, one mapped to '{}', will be registered.", (Object)path);
        registry.registerBeanDefinition(Application.class.getName(), (BeanDefinition)applicationServletBean);
    }

    private GenericBeanDefinition createApplicationServlet(Class<? extends Application> applicationClass, String path) {
        GenericBeanDefinition applicationServletBean = new GenericBeanDefinition();
        applicationServletBean.setFactoryBeanName("JaxrsApplicationServletBuilder");
        applicationServletBean.setFactoryMethodName("build");
        Set<Class<?>> resources = this.allResources;
        ConstructorArgumentValues values = new ConstructorArgumentValues();
        values.addIndexedArgumentValue(0, (Object)applicationClass.getName());
        values.addIndexedArgumentValue(1, (Object)path);
        values.addIndexedArgumentValue(2, resources);
        values.addIndexedArgumentValue(3, this.providers);
        applicationServletBean.setConstructorArgumentValues(values);
        applicationServletBean.setAutowireCandidate(false);
        applicationServletBean.setScope("singleton");
        return applicationServletBean;
    }

    private static enum JaxrsAppClassesRegistration {
        BEANS,
        PROPERTY,
        SCANNING,
        AUTO;

    }
}

