/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.springmvc;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.core.AsynchronousDispatcher;
import org.jboss.resteasy.core.DispatcherUtilities;
import org.jboss.resteasy.core.ResponseInvoker;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.UnhandledException;
import org.jboss.resteasy.springmvc.ResteasyRequestWrapper;
import org.jboss.resteasy.springmvc.ResteasyView;
import org.jboss.resteasy.springmvc.ResteasyWebHandlerTemplate;
import org.springframework.web.servlet.HandlerAdapter;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResteasyHandlerAdapter
extends ResteasyWebHandlerTemplate<ModelAndView>
implements HandlerAdapter {
    public ResteasyHandlerAdapter(SynchronousDispatcher dispatcher) {
        super(dispatcher);
    }

    public long getLastModified(HttpServletRequest request, Object handler) {
        return 0L;
    }

    public ModelAndView handle(HttpServletRequest servletRequest, HttpServletResponse servletResponse, Object handler) throws Exception {
        ResteasyRequestWrapper requestWrapper = (ResteasyRequestWrapper)handler;
        return (ModelAndView)super.handle(requestWrapper, servletResponse);
    }

    @Override
    protected ModelAndView handle(ResteasyRequestWrapper requestWrapper, HttpResponse response) throws IOException {
        AsynchronousDispatcher asyncDispatcher;
        if (requestWrapper.getErrorCode() != null) {
            try {
                response.sendError(requestWrapper.getErrorCode().intValue(), requestWrapper.getErrorMessage());
            }
            catch (Exception e) {
                throw new UnhandledException((Throwable)e);
            }
            return null;
        }
        HttpRequest request = requestWrapper.getHttpRequest();
        if (this.dispatcher instanceof AsynchronousDispatcher && (asyncDispatcher = (AsynchronousDispatcher)this.dispatcher).isAsynchrnousRequest(request)) {
            asyncDispatcher.invoke(request, response);
            return null;
        }
        return this.createModelAndView(requestWrapper, response);
    }

    protected ModelAndView createModelAndView(ResteasyRequestWrapper requestWrapper, HttpResponse response) {
        HttpRequest request = requestWrapper.getHttpRequest();
        DispatcherUtilities utils = this.dispatcher.getDispatcherUtilities();
        utils.pushContextObjects(request, response);
        Response jaxrsResponse = null;
        try {
            jaxrsResponse = requestWrapper.getInvoker().invoke(request, response);
        }
        catch (Exception e) {
            this.dispatcher.handleInvokerException(request, response, e);
        }
        if (jaxrsResponse == null) {
            return null;
        }
        try {
            ResponseInvoker responseInvoker = null;
            Object entity = jaxrsResponse.getEntity();
            if (entity instanceof ModelAndView) {
                utils.outputCookies(response, jaxrsResponse);
                utils.outputHeaders(response, jaxrsResponse);
                return (ModelAndView)entity;
            }
            responseInvoker = utils.resolveResponseInvoker(response, jaxrsResponse);
            return responseInvoker == null ? null : this.createModelAndView(responseInvoker);
        }
        catch (Exception e) {
            this.dispatcher.handleWriteResponseException(request, response, e);
            return null;
        }
    }

    protected ModelAndView createModelAndView(ResponseInvoker responseInvoker) {
        View view = this.createView(responseInvoker);
        return new ModelAndView(view, "responseInvoker", (Object)responseInvoker);
    }

    protected View createView(ResponseInvoker responseInvoker) {
        String contentType = responseInvoker.getContentType().toString();
        return new ResteasyView(contentType, this.dispatcher);
    }

    public boolean supports(Object handler) {
        return handler instanceof ResteasyRequestWrapper;
    }
}

