/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.test;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientRequestFactory;
import org.jboss.resteasy.client.ProxyFactory;

public class TestPortProvider {
    public static final int DEFAULT_PORT = 8081;
    private static final String ENV_VAR_NAME = "RESTEASY_PORT";
    private static final String PROPERTY_NAME = "org.jboss.resteasy.port";
    public static final String ASYNC_JOB_SERVICE_CONTEXT_KEY = "resteasy.async.job.service.enabled";

    public static ClientRequest createClientRequest(String path) {
        return new ClientRequest(TestPortProvider.generateURL(path));
    }

    public static ClientRequest createClientRequest(ClientRequestFactory factory, String path) {
        return factory.createRequest(TestPortProvider.generateURL(path));
    }

    public static <T> T createProxy(Class<T> clazz) {
        return TestPortProvider.createProxy(clazz, "");
    }

    public static <T> T createProxy(Class<T> clazz, String path) {
        return (T)ProxyFactory.create(clazz, (String)TestPortProvider.generateURL(path));
    }

    public static URI createURI(String path) {
        return URI.create(TestPortProvider.generateURL(path));
    }

    public static URL createURL(String path) throws MalformedURLException {
        return new URL(TestPortProvider.generateURL(path));
    }

    public static String generateBaseUrl() {
        return TestPortProvider.generateURL("");
    }

    public static String generateURL(String path) {
        return String.format("http://localhost:%d%s", TestPortProvider.getPort(), path);
    }

    public static int getPort() {
        int port = -1;
        String property = System.getenv(ENV_VAR_NAME);
        if (property != null) {
            try {
                port = Integer.parseInt(property);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (port == -1 && (property = System.getProperty(PROPERTY_NAME)) != null) {
            try {
                port = Integer.parseInt(property);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (port == -1) {
            port = 8081;
        }
        return port;
    }
}

