/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.tracing.api.providers;

import java.util.ArrayList;
import java.util.List;
import org.jboss.resteasy.tracing.api.RESTEasyTracingInfo;
import org.jboss.resteasy.tracing.api.RESTEasyTracingInfoFormat;
import org.jboss.resteasy.tracing.api.RESTEasyTracingMessage;

public class TextBasedRESTEasyTracingInfo
extends RESTEasyTracingInfo {
    protected final List<RESTEasyTracingMessage> messageList = new ArrayList<RESTEasyTracingMessage>();

    protected static String formatPercent(long value, long top) {
        if (value == 0L) {
            return "  ----";
        }
        return String.format("%6.2f", 100.0 * (double)value / (double)top);
    }

    @Override
    public String formatDuration(long duration) {
        if (duration == 0L) {
            return " ----";
        }
        return String.format("%5.2f", (double)duration / 1000000.0);
    }

    protected String formatDuration(long fromTimestamp, long toTimestamp) {
        return this.formatDuration(toTimestamp - fromTimestamp);
    }

    @Override
    public void addMessage(RESTEasyTracingMessage message) {
        this.messageList.add(message);
    }

    @Override
    public boolean supports(RESTEasyTracingInfoFormat format) {
        return format.equals((Object)RESTEasyTracingInfoFormat.TEXT);
    }

    @Override
    public String[] getMessages() {
        long fromTimestamp = this.messageList.get(0).getTimestamp() - this.messageList.get(0).getDuration();
        long toTimestamp = this.messageList.get(this.messageList.size() - 1).getTimestamp();
        String[] messages = new String[this.messageList.size()];
        for (int i = 0; i < messages.length; ++i) {
            RESTEasyTracingMessage message = this.messageList.get(i);
            StringBuilder text = new StringBuilder();
            text.append(String.format("%-11s ", message.getEvent().category()));
            text.append('[').append(this.formatDuration(message.getDuration())).append(" / ").append(this.formatDuration(fromTimestamp, message.getTimestamp())).append(" ms |").append(TextBasedRESTEasyTracingInfo.formatPercent(message.getDuration(), toTimestamp - fromTimestamp)).append(" %] ");
            text.append(message.toString());
            messages[i] = text.toString();
        }
        return messages;
    }
}

