/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.tracing.api;

import java.util.ServiceLoader;
import org.jboss.resteasy.tracing.api.RESTEasyTracingInfoFormat;
import org.jboss.resteasy.tracing.api.RESTEasyTracingMessage;
import org.jboss.resteasy.tracing.api.providers.TextBasedRESTEasyTracingInfo;

public abstract class RESTEasyTracingInfo {
    protected static final ServiceLoader<RESTEasyTracingInfo> INSTANCES;
    protected static final RESTEasyTracingInfo DEFAULT;

    public static RESTEasyTracingInfo get(String format) {
        if (format == null || format.isEmpty()) {
            return DEFAULT;
        }
        if (format.equals(RESTEasyTracingInfoFormat.TEXT.toString())) {
            return new TextBasedRESTEasyTracingInfo();
        }
        if (format.equals(RESTEasyTracingInfoFormat.JSON.toString())) {
            for (RESTEasyTracingInfo instance : INSTANCES) {
                if (!instance.supports(RESTEasyTracingInfoFormat.JSON)) continue;
                return instance;
            }
        }
        return DEFAULT;
    }

    public abstract boolean supports(RESTEasyTracingInfoFormat var1);

    public abstract String[] getMessages();

    public abstract void addMessage(RESTEasyTracingMessage var1);

    public abstract String formatDuration(long var1);

    static {
        DEFAULT = new TextBasedRESTEasyTracingInfo();
        INSTANCES = ServiceLoader.load(RESTEasyTracingInfo.class, Thread.currentThread().getContextClassLoader());
    }
}

