/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.validation;

import com.fasterxml.classmate.Filter;
import com.fasterxml.classmate.MemberResolver;
import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.ResolvedTypeWithMembers;
import com.fasterxml.classmate.TypeResolver;
import com.fasterxml.classmate.members.RawMethod;
import com.fasterxml.classmate.members.ResolvedMethod;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.executable.ExecutableType;
import javax.validation.executable.ValidateOnExecution;
import org.jboss.resteasy.api.validation.ConstraintType;
import org.jboss.resteasy.api.validation.ResteasyConstraintViolation;
import org.jboss.resteasy.api.validation.ResteasyViolationException;
import org.jboss.resteasy.plugins.providers.validation.ConstraintTypeUtil;
import org.jboss.resteasy.plugins.providers.validation.ViolationsContainer;
import org.jboss.resteasy.plugins.validation.ConstraintTypeUtil11;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.validation.GeneralValidator;

public class GeneralValidatorImpl
implements GeneralValidator {
    private TypeResolver typeResolver = new TypeResolver();
    private ValidatorFactory validatorFactory;
    private Validator validator;
    private ConstraintTypeUtil util = new ConstraintTypeUtil11();
    private boolean isExecutableValidationEnabled;
    private ExecutableType[] defaultValidatedExecutableTypes;

    public GeneralValidatorImpl(ValidatorFactory validatorFactory, boolean isExecutableValidationEnabled, Set<ExecutableType> defaultValidatedExecutableTypes) {
        this.validatorFactory = validatorFactory;
        this.isExecutableValidationEnabled = isExecutableValidationEnabled;
        this.defaultValidatedExecutableTypes = defaultValidatedExecutableTypes.toArray(new ExecutableType[0]);
    }

    public void validate(HttpRequest request, Object object, Class<?> ... groups) {
        this.installValidator();
        HashSet<ResteasyConstraintViolation> rcvs = new HashSet<ResteasyConstraintViolation>();
        try {
            Set cvs = this.validator.validate(object, (Class[])groups);
            for (ConstraintViolation cv : cvs) {
                ConstraintType.Type ct = this.util.getConstraintType((Object)cv);
                rcvs.add(new ResteasyConstraintViolation(ct, cv.getPropertyPath().toString(), cv.getMessage(), cv.getInvalidValue().toString()));
            }
        }
        catch (Exception e) {
            ViolationsContainer<Object> violationsContainer = this.getViolationsContainer(request);
            violationsContainer.setException(e);
            throw new ResteasyViolationException(violationsContainer);
        }
        ViolationsContainer<Object> violationsContainer = this.getViolationsContainer(request);
        violationsContainer.addViolations(rcvs);
    }

    protected ViolationsContainer<Object> getViolationsContainer(HttpRequest request) {
        ViolationsContainer violationsContainer = (ViolationsContainer)ViolationsContainer.class.cast(request.getAttribute(ViolationsContainer.class.getName()));
        if (violationsContainer == null) {
            violationsContainer = new ViolationsContainer();
            request.setAttribute(ViolationsContainer.class.getName(), (Object)violationsContainer);
        }
        return violationsContainer;
    }

    public void checkViolations(HttpRequest request) {
        ViolationsContainer violationsContainer = (ViolationsContainer)ViolationsContainer.class.cast(request.getAttribute(ViolationsContainer.class.getName()));
        if (violationsContainer != null && violationsContainer.size() > 0) {
            throw new ResteasyViolationException(violationsContainer);
        }
    }

    public void validateAllParameters(HttpRequest request, Object object, Method method, Object[] parameterValues, Class<?> ... groups) {
        if (method.getParameterTypes().length == 0) {
            this.checkViolations(request);
            return;
        }
        this.installValidator();
        ViolationsContainer<Object> violationsContainer = this.getViolationsContainer(request);
        HashSet<ResteasyConstraintViolation> rcvs = new HashSet<ResteasyConstraintViolation>();
        try {
            Set cvs = this.validator.forExecutables().validateParameters(object, method, parameterValues, (Class[])groups);
            for (ConstraintViolation cv : cvs) {
                ConstraintType.Type ct = this.util.getConstraintType((Object)cv);
                rcvs.add(new ResteasyConstraintViolation(ct, cv.getPropertyPath().toString(), cv.getMessage(), GeneralValidatorImpl.convertArrayToString(cv.getInvalidValue())));
            }
        }
        catch (Exception e) {
            violationsContainer.setException(e);
            throw new ResteasyViolationException(violationsContainer);
        }
        violationsContainer.addViolations(rcvs);
        if (violationsContainer.size() > 0) {
            throw new ResteasyViolationException(violationsContainer);
        }
    }

    public void validateReturnValue(HttpRequest request, Object object, Method method, Object returnValue, Class<?> ... groups) {
        this.installValidator();
        HashSet<ResteasyConstraintViolation> rcvs = new HashSet<ResteasyConstraintViolation>();
        ViolationsContainer<Object> violationsContainer = this.getViolationsContainer(request);
        try {
            Set cvs = this.validator.forExecutables().validateReturnValue(object, method, returnValue, (Class[])groups);
            for (ConstraintViolation cv : cvs) {
                ConstraintType.Type ct = this.util.getConstraintType((Object)cv);
                rcvs.add(new ResteasyConstraintViolation(ct, cv.getPropertyPath().toString(), cv.getMessage(), cv.getInvalidValue().toString()));
            }
        }
        catch (Exception e) {
            violationsContainer.setException(e);
            throw new ResteasyViolationException(violationsContainer);
        }
        violationsContainer.addViolations(rcvs);
        if (violationsContainer.size() > 0) {
            throw new ResteasyViolationException(violationsContainer);
        }
    }

    public boolean isValidatable(Class<?> clazz) {
        return true;
    }

    public boolean isMethodValidatable(Method m) {
        ValidateOnExecution voe;
        if (!this.isExecutableValidationEnabled) {
            return false;
        }
        ExecutableType[] types = null;
        List<ExecutableType[]> typesList = this.getExecutableTypesOnMethodInHierarchy(m);
        if (typesList.size() > 1) {
            throw new ValidationException("@ValidateOnExecution found on multiple overridden methods");
        }
        types = typesList.size() == 1 ? typesList.get(0) : ((voe = m.getDeclaringClass().getAnnotation(ValidateOnExecution.class)) == null ? this.defaultValidatedExecutableTypes : (voe.type().length > 0 ? voe.type() : this.defaultValidatedExecutableTypes));
        boolean isGetterMethod = GeneralValidatorImpl.isGetter(m);
        block6: for (int i = 0; i < types.length; ++i) {
            switch (types[i]) {
                case IMPLICIT: 
                case ALL: {
                    return true;
                }
                case NONE: {
                    continue block6;
                }
                case NON_GETTER_METHODS: {
                    if (isGetterMethod) continue block6;
                    return true;
                }
                case GETTER_METHODS: {
                    if (!isGetterMethod) continue block6;
                    return true;
                }
            }
        }
        return false;
    }

    protected List<ExecutableType[]> getExecutableTypesOnMethodInHierarchy(Method method) {
        ArrayList<ExecutableType[]> typesList = new ArrayList<ExecutableType[]>();
        for (Class<?> clazz = method.getDeclaringClass(); clazz != null; clazz = clazz.getSuperclass()) {
            ExecutableType[] types;
            Method superMethod = this.getSuperMethod(method, clazz);
            if (superMethod != null && (types = GeneralValidatorImpl.getExecutableTypesOnMethod(superMethod)) != null) {
                typesList.add(types);
            }
            typesList.addAll(this.getExecutableTypesOnMethodInInterfaces(clazz, method));
        }
        return typesList;
    }

    protected List<ExecutableType[]> getExecutableTypesOnMethodInInterfaces(Class<?> clazz, Method method) {
        ArrayList<ExecutableType[]> typesList = new ArrayList<ExecutableType[]>();
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            List<ExecutableType[]> superList;
            ExecutableType[] types;
            Method interfaceMethod = this.getSuperMethod(method, interfaces[i]);
            if (interfaceMethod != null && (types = GeneralValidatorImpl.getExecutableTypesOnMethod(interfaceMethod)) != null) {
                typesList.add(types);
            }
            if ((superList = this.getExecutableTypesOnMethodInInterfaces(interfaces[i], method)).size() <= 0) continue;
            typesList.addAll(superList);
        }
        return typesList;
    }

    protected static ExecutableType[] getExecutableTypesOnMethod(Method method) {
        ValidateOnExecution voe = method.getAnnotation(ValidateOnExecution.class);
        if (voe == null || voe.type().length == 0) {
            return null;
        }
        ExecutableType[] types = voe.type();
        if (types == null || types.length == 0) {
            return null;
        }
        return types;
    }

    protected static boolean isGetter(Method m) {
        String name = m.getName();
        Class<?> returnType = m.getReturnType();
        if (returnType.equals(Void.class)) {
            return false;
        }
        if (m.getParameterTypes().length > 0) {
            return false;
        }
        if (name.startsWith("get")) {
            return true;
        }
        return name.startsWith("is") && returnType.equals(Boolean.TYPE);
    }

    protected static String convertArrayToString(Object o) {
        String result = null;
        if (o instanceof Object[]) {
            Object[] array = (Object[])Object[].class.cast(o);
            StringBuffer sb = new StringBuffer("[").append(GeneralValidatorImpl.convertArrayToString(array[0]));
            for (int i = 1; i < array.length; ++i) {
                sb.append(", ").append(GeneralValidatorImpl.convertArrayToString(array[i]));
            }
            sb.append("]");
            result = sb.toString();
        } else {
            result = o == null ? "" : o.toString();
        }
        return result;
    }

    protected Method getSuperMethod(Method method, Class<?> clazz) {
        Method[] methods = clazz.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!this.overrides(method, methods[i])) continue;
            return methods[i];
        }
        return null;
    }

    protected boolean overrides(Method subTypeMethod, Method superTypeMethod) {
        if (subTypeMethod == null || superTypeMethod == null) {
            throw new RuntimeException("Expect two non-null methods");
        }
        if (!subTypeMethod.getName().equals(superTypeMethod.getName())) {
            return false;
        }
        if (subTypeMethod.getParameterTypes().length != superTypeMethod.getParameterTypes().length) {
            return false;
        }
        if (!superTypeMethod.getDeclaringClass().isAssignableFrom(subTypeMethod.getDeclaringClass())) {
            return false;
        }
        return this.parametersResolveToSameTypes(subTypeMethod, superTypeMethod);
    }

    protected boolean parametersResolveToSameTypes(Method subTypeMethod, Method superTypeMethod) {
        if (subTypeMethod.getParameterTypes().length == 0) {
            return true;
        }
        ResolvedType resolvedSubType = this.typeResolver.resolve(subTypeMethod.getDeclaringClass(), new Type[0]);
        MemberResolver memberResolver = new MemberResolver(this.typeResolver);
        memberResolver.setMethodFilter((Filter)new SimpleMethodFilter(subTypeMethod, superTypeMethod));
        ResolvedTypeWithMembers typeWithMembers = memberResolver.resolve(resolvedSubType, null, null);
        ResolvedMethod[] resolvedMethods = typeWithMembers.getMemberMethods();
        if (resolvedMethods.length == 1) {
            return true;
        }
        for (int i = 0; i < resolvedMethods[0].getArgumentCount(); ++i) {
            if (resolvedMethods[0].getArgumentType(i).equals((Object)resolvedMethods[1].getArgumentType(i))) continue;
            return false;
        }
        return true;
    }

    protected void installValidator() {
        if (this.validator == null) {
            this.validator = this.validatorFactory.getValidator();
        }
    }

    protected static class SimpleMethodFilter
    implements Filter<RawMethod> {
        private final Method method1;
        private final Method method2;

        private SimpleMethodFilter(Method method1, Method method2) {
            this.method1 = method1;
            this.method2 = method2;
        }

        public boolean include(RawMethod element) {
            return element.getRawMember().equals(this.method1) || element.getRawMember().equals(this.method2);
        }
    }
}

