/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.vertx;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.JsonObject;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.resteasy.plugins.server.embedded.EmbeddedJaxrsServer;
import org.jboss.resteasy.plugins.server.embedded.SecurityDomain;
import org.jboss.resteasy.plugins.server.vertx.VertxRequestHandler;
import org.jboss.resteasy.plugins.server.vertx.VertxResteasyDeployment;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.jboss.resteasy.util.EmbeddedServerHelper;
import org.jboss.resteasy.util.PortProvider;

public class VertxJaxrsServer
implements EmbeddedJaxrsServer<VertxJaxrsServer> {
    private static final ConcurrentMap<String, Helper> deploymentMap = new ConcurrentHashMap<String, Helper>();
    protected VertxOptions vertxOptions = new VertxOptions();
    protected Vertx vertx;
    protected HttpServerOptions serverOptions = new HttpServerOptions();
    protected VertxResteasyDeployment deployment;
    protected String root = "";
    protected SecurityDomain domain;
    private String deploymentID;
    private EmbeddedServerHelper serverHelper = new EmbeddedServerHelper();

    public VertxJaxrsServer() {
        this.serverOptions.setPort(PortProvider.getPort());
    }

    public VertxJaxrsServer deploy() {
        return this;
    }

    public VertxJaxrsServer start() {
        String aPath;
        if (this.deployment == null) {
            throw new IllegalArgumentException("A ResteasyDeployment object required");
        }
        if (this.deployment.getProviderFactory() == null) {
            this.deployment.start();
        }
        if ((aPath = this.serverHelper.checkAppDeployment((ResteasyDeployment)this.deployment)) == null) {
            aPath = this.root;
        }
        this.setRootResourcePath(this.serverHelper.checkContextPath(aPath));
        this.vertx = Vertx.vertx((VertxOptions)this.vertxOptions);
        String key = UUID.randomUUID().toString();
        deploymentMap.put(key, new Helper(this.root, this.serverOptions, (ResteasyDeployment)this.deployment, this.domain));
        CompletableFuture fut = new CompletableFuture();
        DeploymentOptions deploymentOptions = new DeploymentOptions().setInstances(this.vertxOptions.getEventLoopPoolSize()).setConfig(new JsonObject().put("helper", (Object)key));
        this.vertx.deployVerticle(Verticle.class.getName(), deploymentOptions, ar -> {
            deploymentMap.remove(key);
            if (ar.succeeded()) {
                fut.complete((String)ar.result());
            } else {
                fut.completeExceptionally(ar.cause());
            }
        });
        try {
            this.deploymentID = (String)fut.get(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public void stop() {
        if (this.deploymentID != null) {
            CompletableFuture fut = new CompletableFuture();
            this.vertx.close(ar -> fut.complete(null));
            this.deploymentID = null;
            try {
                fut.get(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.deployment != null) {
            this.deployment.stop();
        }
    }

    public ResteasyDeployment getDeployment() {
        if (this.deployment == null) {
            this.deployment = new VertxResteasyDeployment();
        }
        return this.deployment;
    }

    public VertxJaxrsServer setDeployment(ResteasyDeployment deployment) {
        this.deployment = (VertxResteasyDeployment)deployment;
        return this;
    }

    public VertxJaxrsServer setPort(int port) {
        this.serverOptions.setPort(port);
        return this;
    }

    public int getPort() {
        return this.serverOptions.getPort();
    }

    public VertxJaxrsServer setHostname(String hostname) {
        this.serverOptions.setHost(hostname);
        return this;
    }

    public String getHostname() {
        return this.serverOptions.getHost();
    }

    public VertxJaxrsServer setRootResourcePath(String rootResourcePath) {
        this.root = rootResourcePath;
        if (this.root != null && this.root.equals("/")) {
            this.root = "";
        }
        return this;
    }

    public VertxJaxrsServer setSecurityDomain(SecurityDomain sc) {
        this.domain = sc;
        return this;
    }

    public VertxOptions getVertxOptions() {
        return this.vertxOptions;
    }

    public VertxJaxrsServer setVertxOptions(VertxOptions options) {
        this.vertxOptions = options;
        return this;
    }

    public VertxJaxrsServer setServerOptions(HttpServerOptions options) {
        this.serverOptions = options;
        return this;
    }

    public HttpServerOptions getServerOptions() {
        return this.serverOptions;
    }

    private static class Helper {
        final String root;
        final HttpServerOptions serverOptions;
        final ResteasyDeployment deployment;
        final SecurityDomain domain;

        Helper(String root, HttpServerOptions serverOptions, ResteasyDeployment deployment, SecurityDomain domain) {
            this.root = root;
            this.serverOptions = serverOptions;
            this.deployment = deployment;
            this.domain = domain;
        }

        public Handler<HttpServerRequest> createHandler(Vertx vertx) {
            return new VertxRequestHandler(vertx, this.deployment, this.root, this.domain);
        }
    }

    public static class Verticle
    extends AbstractVerticle {
        protected HttpServer server;

        public void start(Promise<Void> startPromise) throws Exception {
            Helper helper = (Helper)deploymentMap.get(this.config().getString("helper"));
            this.server = this.vertx.createHttpServer(helper.serverOptions);
            this.server.requestHandler((Handler)new VertxRequestHandler(this.vertx, helper.deployment, helper.root, helper.domain));
            this.server.listen(ar -> {
                if (ar.succeeded()) {
                    startPromise.complete();
                } else {
                    startPromise.fail(ar.cause());
                }
            });
        }
    }
}

