/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.ext.Provider;
import org.ho.yaml.Yaml;
import org.ho.yaml.exception.YamlException;
import org.jboss.resteasy.plugins.providers.AbstractEntityProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Consumes(value={"text/yaml", "text/x-yaml", "application/x-yaml"})
@Produces(value={"text/yaml", "text/x-yaml", "application/x-yaml"})
public class YamlProvider
extends AbstractEntityProvider<Object> {
    static final Logger logger = LoggerFactory.getLogger(YamlProvider.class);

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        try {
            return Yaml.load((InputStream)entityStream);
        }
        catch (YamlException ye) {
            logger.debug("Failed to decode Yaml: {}", (Object)ye.getMessage());
            throw new WebApplicationException((Throwable)ye, 400);
        }
        catch (Exception e) {
            logger.debug("Failed to decode Yaml: {}", (Object)e.getMessage());
            throw new WebApplicationException((Throwable)e, 400);
        }
    }

    protected boolean isValidType(Class type) {
        if (List.class.isAssignableFrom(type) || Set.class.isAssignableFrom(type) || Map.class.isAssignableFrom(type) || type.isArray()) {
            return true;
        }
        if (StreamingOutput.class.isAssignableFrom(type)) {
            return false;
        }
        String className = type.getName();
        if (className.startsWith("java.")) {
            return false;
        }
        if (className.startsWith("javax.")) {
            return false;
        }
        return !type.isPrimitive();
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.isValidType(type);
    }

    public void writeTo(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        try {
            Yaml.dump((Object)t, (OutputStream)entityStream);
        }
        catch (Exception e) {
            logger.debug("Failed to encode yaml for object: {}", (Object)t.toString());
            throw new WebApplicationException((Throwable)e, 500);
        }
    }
}

