/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.skeleton.key.idm.adapters.infinispan;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.Cache;
import org.jboss.resteasy.skeleton.key.idm.IdentityManager;
import org.jboss.resteasy.skeleton.key.idm.model.data.Realm;
import org.jboss.resteasy.skeleton.key.idm.model.data.RequiredCredential;
import org.jboss.resteasy.skeleton.key.idm.model.data.Resource;
import org.jboss.resteasy.skeleton.key.idm.model.data.Role;
import org.jboss.resteasy.skeleton.key.idm.model.data.RoleMapping;
import org.jboss.resteasy.skeleton.key.idm.model.data.ScopeMapping;
import org.jboss.resteasy.skeleton.key.idm.model.data.User;
import org.jboss.resteasy.skeleton.key.idm.model.data.UserAttribute;
import org.jboss.resteasy.skeleton.key.idm.model.data.UserCredential;
import org.jboss.resteasy.spi.NotImplementedYetException;

public class InfinispanIDM
implements IdentityManager {
    private static AtomicLong counter = new AtomicLong(1L);
    protected Cache cache;

    private static String generateId() {
        return counter.getAndIncrement() + "-" + System.currentTimeMillis();
    }

    public InfinispanIDM(Cache cache) {
        this.cache = cache;
    }

    @Override
    public Realm getRealm(String id) {
        return (Realm)this.cache.get((Object)("/realms/" + id));
    }

    @Override
    public List<Realm> getRealmsByName(String name) {
        Set realms = (Set)this.cache.get((Object)("/realms/names/" + name));
        ArrayList<Realm> list = new ArrayList<Realm>();
        if (realms == null) {
            return list;
        }
        for (String id : realms) {
            Realm realm = this.getRealm(id);
            if (realm == null) continue;
            list.add(realm);
        }
        return list;
    }

    @Override
    public Realm create(Realm realm) {
        realm.setId(InfinispanIDM.generateId());
        this.cache.put((Object)this.realmKey(realm), (Object)realm);
        HashSet<String> realms = (HashSet<String>)this.cache.get((Object)("/realms/names/" + realm.getName()));
        if (realms == null) {
            realms = new HashSet<String>();
        }
        realms.add(realm.getId());
        this.cache.put((Object)("/realms/names/" + realm.getName()), realms);
        return realm;
    }

    @Override
    public void update(Realm realm) {
        this.cache.put((Object)this.realmKey(realm), (Object)realm);
    }

    protected String realmKey(Realm realm) {
        return "/realms/" + realm.getId();
    }

    @Override
    public void delete(Realm realm) {
        throw new NotImplementedYetException();
    }

    @Override
    public List<RequiredCredential> getRequiredCredentials(Realm realm) {
        Set creds = (Set)this.cache.get((Object)(this.realmKey(realm) + "/RequiredCredentials"));
        ArrayList<RequiredCredential> list = new ArrayList<RequiredCredential>();
        if (creds != null) {
            for (String id : creds) {
                RequiredCredential cred = this.getRealmCredential(id);
                list.add(cred);
            }
        }
        return list;
    }

    @Override
    public RequiredCredential create(Realm realm, RequiredCredential cred) {
        cred.setId(InfinispanIDM.generateId());
        this.cache.put((Object)("/RequiredCredentials/" + cred.getId()), (Object)cred);
        HashSet<String> creds = (HashSet<String>)this.cache.get((Object)(this.realmKey(realm) + "/RequiredCredentials"));
        if (creds == null) {
            creds = new HashSet<String>();
        }
        creds.add(cred.getId());
        this.cache.put((Object)(this.realmKey(realm) + "/RequiredCredentials"), creds);
        return cred;
    }

    @Override
    public RequiredCredential getRealmCredential(String id) {
        return (RequiredCredential)this.cache.get((Object)("/RequiredCredentials/" + id));
    }

    @Override
    public void update(RequiredCredential cred) {
        this.cache.put((Object)("/RequiredCredentials/" + cred.getId()), (Object)cred);
    }

    @Override
    public void delete(RequiredCredential cred) {
        throw new NotImplementedYetException();
    }

    @Override
    public User create(Realm realm, User user) {
        user.setId(InfinispanIDM.generateId());
        this.cache.put((Object)("/users/" + user.getId()), (Object)user);
        this.cache.put((Object)(this.realmKey(realm) + "/users/" + user.getUsername()), (Object)user.getId());
        return user;
    }

    @Override
    public User getUser(Realm realm, String username) {
        String id = (String)this.cache.get((Object)(this.realmKey(realm) + "/users/" + username));
        if (id == null) {
            return null;
        }
        return (User)this.cache.get((Object)("/users/" + id));
    }

    @Override
    public void update(User user) {
        this.cache.put((Object)("/users/" + user.getId()), (Object)user);
    }

    @Override
    public void delete(User user) {
        throw new NotImplementedYetException();
    }

    @Override
    public UserCredential create(User user, UserCredential cred) {
        cred.setId(InfinispanIDM.generateId());
        this.cache.put((Object)("/UserCredentials/" + cred.getId()), (Object)cred);
        HashSet<String> creds = (HashSet<String>)this.cache.get((Object)("/users/" + user.getId() + "/UserCredentials"));
        if (creds == null) {
            creds = new HashSet<String>();
        }
        creds.add(cred.getId());
        this.cache.put((Object)("/users/" + user.getId() + "/UserCredentials"), creds);
        return cred;
    }

    @Override
    public List<UserCredential> getCredentials(User user) {
        Set creds = (Set)this.cache.get((Object)("/users/" + user.getId() + "/UserCredentials"));
        ArrayList<UserCredential> list = new ArrayList<UserCredential>();
        if (creds != null) {
            for (String id : creds) {
                UserCredential cred = this.getCredential(id);
                list.add(cred);
            }
        }
        return list;
    }

    @Override
    public UserCredential getCredential(String id) {
        return (UserCredential)this.cache.get((Object)("/UserCredentials/" + id));
    }

    @Override
    public void update(UserCredential cred) {
        this.cache.put((Object)("/UserCredentials/" + cred.getId()), (Object)cred);
    }

    @Override
    public void delete(UserCredential cred) {
        throw new NotImplementedYetException();
    }

    @Override
    public UserAttribute getUserAttribute(String id) {
        return (UserAttribute)this.cache.get((Object)("/UserAtributes/" + id));
    }

    @Override
    public UserAttribute create(User user, UserAttribute attribute) {
        attribute.setId(InfinispanIDM.generateId());
        this.cache.put((Object)("/UserAttributes/" + attribute.getId()), (Object)attribute);
        HashSet<String> creds = (HashSet<String>)this.cache.get((Object)("/users/" + user.getId() + "/UserAttributes"));
        if (creds == null) {
            creds = new HashSet<String>();
        }
        creds.add(attribute.getId());
        this.cache.put((Object)("/users/" + user.getId() + "/UserAttributes"), creds);
        return attribute;
    }

    @Override
    public void update(UserAttribute attribute) {
        this.cache.put((Object)("/UserAttributes/" + attribute.getId()), (Object)attribute);
    }

    @Override
    public void delete(UserAttribute attribute) {
        throw new NotImplementedYetException();
    }

    @Override
    public Resource getResource(String id) {
        return (Resource)this.cache.get((Object)("/resources/" + id));
    }

    @Override
    public Resource getResource(Realm realm, String name) {
        String id = (String)this.cache.get((Object)(this.realmKey(realm) + "/resources/" + name));
        if (id == null) {
            return null;
        }
        return this.getResource(id);
    }

    @Override
    public List<Resource> getResources(Realm realm) {
        Set resources = (Set)this.cache.get((Object)(this.realmKey(realm) + "/resources"));
        ArrayList<Resource> list = new ArrayList<Resource>();
        if (resources != null) {
            for (String id : resources) {
                list.add(this.getResource(id));
            }
        }
        return list;
    }

    @Override
    public Resource create(Realm realm, Resource resource) {
        resource.setId(InfinispanIDM.generateId());
        this.cache.put((Object)("/resources/" + resource.getId()), (Object)resource);
        this.cache.put((Object)(this.realmKey(realm) + "/resources/" + resource.getName()), (Object)resource.getId());
        HashSet<String> resources = (HashSet<String>)this.cache.get((Object)(this.realmKey(realm) + "/resources"));
        if (resources == null) {
            resources = new HashSet<String>();
        }
        resources.add(resource.getId());
        this.cache.put((Object)(this.realmKey(realm) + "/resources"), resources);
        return resource;
    }

    @Override
    public void update(Resource resource) {
        this.cache.put((Object)("/resources/" + resource.getId()), (Object)resource);
    }

    @Override
    public void delete(Resource resource) {
        throw new NotImplementedYetException();
    }

    @Override
    public Role getRoleByName(Realm realm, String roleName) {
        String id = (String)this.cache.get((Object)(this.realmKey(realm) + "/roles/" + roleName));
        if (id == null) {
            return null;
        }
        return this.getRole(id);
    }

    @Override
    public Role getRoleByName(Resource resource, String roleName) {
        String id = (String)this.cache.get((Object)("/resources/" + resource.getId() + "/roles/" + roleName));
        if (id == null) {
            return null;
        }
        return this.getRole(id);
    }

    @Override
    public List<Role> getRoles(Realm realm, Resource resource) {
        Set roles = (Set)this.cache.get((Object)("/resources/" + resource.getId() + "/roles"));
        ArrayList<Role> list = new ArrayList<Role>();
        if (roles != null) {
            for (String id : roles) {
                list.add(this.getRole(id));
            }
        }
        return list;
    }

    @Override
    public List<Role> getRoles(Realm realm) {
        Set roles = (Set)this.cache.get((Object)(this.realmKey(realm) + "/roles"));
        ArrayList<Role> list = new ArrayList<Role>();
        if (roles != null) {
            for (String id : roles) {
                list.add(this.getRole(id));
            }
        }
        return list;
    }

    @Override
    public Role getRole(String id) {
        return (Role)this.cache.get((Object)("/roles/" + id));
    }

    @Override
    public Role create(Realm realm, Resource resource, String roleName) {
        Role role = new Role();
        role.setName(roleName);
        role.setId(InfinispanIDM.generateId());
        this.cache.put((Object)("/roles/" + role.getId()), (Object)role);
        HashSet<String> roles = (HashSet<String>)this.cache.get((Object)("/resources/" + resource.getId() + "/roles"));
        if (roles == null) {
            roles = new HashSet<String>();
        }
        roles.add(role.getId());
        this.cache.put((Object)("/resources/" + resource.getId() + "/roles"), roles);
        this.cache.put((Object)("/resources/" + resource.getId() + "/roles/" + role.getName()), (Object)role.getId());
        return role;
    }

    @Override
    public Role create(Realm realm, String roleName) {
        Role role = new Role();
        role.setName(roleName);
        role.setId(InfinispanIDM.generateId());
        this.cache.put((Object)("/roles/" + role.getId()), (Object)role);
        HashSet<String> roles = (HashSet<String>)this.cache.get((Object)(this.realmKey(realm) + "/roles"));
        if (roles == null) {
            roles = new HashSet<String>();
        }
        roles.add(role.getId());
        this.cache.put((Object)(this.realmKey(realm) + "/roles"), roles);
        this.cache.put((Object)(this.realmKey(realm) + "/roles/" + role.getName()), (Object)role.getId());
        return role;
    }

    @Override
    public void delete(Role role) {
        throw new NotImplementedYetException();
    }

    @Override
    public List<RoleMapping> getRoleMappings(Realm realm) {
        Set mappings = (Set)this.cache.get((Object)("/realms/" + realm.getId() + "/RoleMappings"));
        ArrayList<RoleMapping> list = new ArrayList<RoleMapping>();
        if (mappings != null) {
            for (String id : mappings) {
                list.add(this.getRoleMapping(id));
            }
        }
        return list;
    }

    @Override
    public List<RoleMapping> getRoleMappings(Realm realm, Resource resource) {
        Set mappings = (Set)this.cache.get((Object)("/resources/" + resource.getId() + "/RoleMappings"));
        ArrayList<RoleMapping> list = new ArrayList<RoleMapping>();
        if (mappings != null) {
            for (String id : mappings) {
                list.add(this.getRoleMapping(id));
            }
        }
        return list;
    }

    @Override
    public RoleMapping getRoleMapping(Realm realm, User user) {
        String id = (String)this.cache.get((Object)("/realms/" + realm.getId() + "/RoleMappings/users/" + user.getId()));
        return this.getRoleMapping(id);
    }

    @Override
    public RoleMapping getRoleMapping(Realm realm, Resource resource, User user) {
        String id = (String)this.cache.get((Object)("/resources/" + resource.getId() + "/RoleMappings/users/" + user.getId()));
        return this.getRoleMapping(id);
    }

    @Override
    public RoleMapping getRoleMapping(String id) {
        return (RoleMapping)this.cache.get((Object)("/RoleMappings/" + id));
    }

    @Override
    public RoleMapping create(Realm realm, User user, RoleMapping mapping) {
        mapping.setId(InfinispanIDM.generateId());
        mapping.setUserid(user.getId());
        this.cache.put((Object)("/RoleMappings/" + mapping.getId()), (Object)mapping);
        this.cache.put((Object)(this.realmKey(realm) + "/RoleMappings/users/" + user.getId()), (Object)mapping.getId());
        HashSet<String> mappings = (HashSet<String>)this.cache.get((Object)(this.realmKey(realm) + "/RoleMappings"));
        if (mappings == null) {
            mappings = new HashSet<String>();
        }
        mappings.add(mapping.getId());
        this.cache.put((Object)(this.realmKey(realm) + "/RoleMappings"), mappings);
        return mapping;
    }

    @Override
    public RoleMapping create(Realm realm, Resource resource, User user, RoleMapping mapping) {
        mapping.setId(InfinispanIDM.generateId());
        mapping.setUserid(user.getId());
        this.cache.put((Object)("/RoleMappings/" + mapping.getId()), (Object)mapping);
        this.cache.put((Object)("/resources/" + resource.getId() + "/RoleMappings/users/" + user.getId()), (Object)mapping.getId());
        HashSet<String> mappings = (HashSet<String>)this.cache.get((Object)("/resources/" + resource.getId() + "/RoleMappings"));
        if (mappings == null) {
            mappings = new HashSet<String>();
        }
        mappings.add(mapping.getId());
        this.cache.put((Object)("/resources/" + resource.getId() + "/RoleMappings"), mappings);
        return mapping;
    }

    @Override
    public void delete(RoleMapping role) {
        throw new NotImplementedYetException();
    }

    @Override
    public List<ScopeMapping> getScopeMappings(Realm realm) {
        Set mappings = (Set)this.cache.get((Object)("/realms/" + realm.getId() + "/ScopeMappings"));
        ArrayList<ScopeMapping> list = new ArrayList<ScopeMapping>();
        if (mappings != null) {
            for (String id : mappings) {
                list.add(this.getScopeMapping(id));
            }
        }
        return list;
    }

    @Override
    public List<ScopeMapping> getScopeMappings(Realm realm, Resource resource) {
        Set mappings = (Set)this.cache.get((Object)("/resources/" + resource.getId() + "/ScopeMappings"));
        ArrayList<ScopeMapping> list = new ArrayList<ScopeMapping>();
        if (mappings != null) {
            for (String id : mappings) {
                list.add(this.getScopeMapping(id));
            }
        }
        return list;
    }

    @Override
    public ScopeMapping getScopeMapping(Realm realm, User user) {
        String id = (String)this.cache.get((Object)("/realms/" + realm.getId() + "/ScopeMappings/users/" + user.getId()));
        return this.getScopeMapping(id);
    }

    @Override
    public ScopeMapping getScopeMapping(Realm realm, Resource resource, User user) {
        String id = (String)this.cache.get((Object)("/resources/" + resource.getId() + "/ScopeMappings/users/" + user.getId()));
        return this.getScopeMapping(id);
    }

    @Override
    public ScopeMapping getScopeMapping(String id) {
        return (ScopeMapping)this.cache.get((Object)("/ScopeMappings/" + id));
    }

    @Override
    public ScopeMapping create(Realm realm, User user, ScopeMapping mapping) {
        mapping.setId(InfinispanIDM.generateId());
        mapping.setUserid(user.getId());
        this.cache.put((Object)("/ScopeMappings/" + mapping.getId()), (Object)mapping);
        this.cache.put((Object)(this.realmKey(realm) + "/ScopeMappings/users/" + user.getId()), (Object)mapping.getId());
        HashSet<String> mappings = (HashSet<String>)this.cache.get((Object)(this.realmKey(realm) + "/ScopeMappings"));
        if (mappings == null) {
            mappings = new HashSet<String>();
        }
        mappings.add(mapping.getId());
        this.cache.put((Object)(this.realmKey(realm) + "/ScopeMappings"), mappings);
        return mapping;
    }

    @Override
    public ScopeMapping create(Realm realm, Resource resource, User user, ScopeMapping mapping) {
        mapping.setId(InfinispanIDM.generateId());
        mapping.setUserid(user.getId());
        this.cache.put((Object)("/ScopeMappings/" + mapping.getId()), (Object)mapping);
        this.cache.put((Object)("/resources/" + resource.getId() + "/ScopeMappings/users/" + user.getId()), (Object)mapping.getId());
        HashSet<String> mappings = (HashSet<String>)this.cache.get((Object)("/resources/" + resource.getId() + "/ScopeMappings"));
        if (mappings == null) {
            mappings = new HashSet<String>();
        }
        mappings.add(mapping.getId());
        this.cache.put((Object)("/resources/" + resource.getId() + "/ScopeMappings"), mappings);
        return mapping;
    }

    @Override
    public void delete(ScopeMapping scope) {
        throw new NotImplementedYetException();
    }
}

