/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.skeleton.key.idm.service;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import javax.ws.rs.Consumes;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Providers;
import org.jboss.resteasy.jose.Base64Url;
import org.jboss.resteasy.jose.jws.JWSBuilder;
import org.jboss.resteasy.jose.jws.JWSInput;
import org.jboss.resteasy.jose.jws.crypto.RSAProvider;
import org.jboss.resteasy.jwt.JsonSerialization;
import org.jboss.resteasy.logging.Logger;
import org.jboss.resteasy.skeleton.key.idm.IdentityManager;
import org.jboss.resteasy.skeleton.key.idm.model.data.Realm;
import org.jboss.resteasy.skeleton.key.idm.model.data.RequiredCredential;
import org.jboss.resteasy.skeleton.key.idm.model.data.Resource;
import org.jboss.resteasy.skeleton.key.idm.model.data.RoleMapping;
import org.jboss.resteasy.skeleton.key.idm.model.data.ScopeMapping;
import org.jboss.resteasy.skeleton.key.idm.model.data.User;
import org.jboss.resteasy.skeleton.key.idm.model.data.UserCredential;
import org.jboss.resteasy.skeleton.key.representations.AccessTokenResponse;
import org.jboss.resteasy.skeleton.key.representations.SkeletonKeyScope;
import org.jboss.resteasy.skeleton.key.representations.SkeletonKeyToken;
import org.jboss.resteasy.spi.NotImplementedYetException;
import org.jboss.resteasy.util.Base64;

@Path(value="/realms")
public class TokenManagement {
    protected IdentityManager identityManager;
    protected Logger logger = Logger.getLogger(TokenManagement.class);
    protected Map<String, AccessCode> accessCodeMap = new HashMap<String, AccessCode>();
    @Context
    protected UriInfo uriInfo;
    @Context
    protected Providers providers;
    @Context
    protected SecurityContext securityContext;
    @Context
    protected HttpHeaders headers;
    private static AtomicLong counter = new AtomicLong(1L);

    public TokenManagement(IdentityManager identityManager) {
        this.identityManager = identityManager;
    }

    private static String generateId() {
        return counter.getAndIncrement() + "." + UUID.randomUUID().toString();
    }

    protected SkeletonKeyToken createAccessToken(User user, Realm realm) {
        RoleMapping realmMapping;
        List<Resource> resources = this.identityManager.getResources(realm);
        SkeletonKeyToken token = new SkeletonKeyToken();
        token.id(TokenManagement.generateId());
        token.principal(user.getUsername());
        token.audience(realm.getName());
        if (realm.getTokenLifespan() > 0L) {
            token.expiration(System.currentTimeMillis() / 1000L + realm.getTokenLifespan());
        }
        if ((realmMapping = this.identityManager.getRoleMapping(realm, user)) != null && realmMapping.getRoles().size() > 0) {
            SkeletonKeyToken.Access access = new SkeletonKeyToken.Access();
            for (String role : realmMapping.getRoles()) {
                access.addRole(role);
            }
            token.setRealmAccess(access);
        }
        for (Resource resource : resources) {
            RoleMapping mapping = this.identityManager.getRoleMapping(realm, resource, user);
            if (mapping == null) continue;
            SkeletonKeyToken.Access access = token.addAccess(resource.getName()).verifyCaller(Boolean.valueOf(resource.isSurrogateAuthRequired()));
            for (String role : mapping.getRoles()) {
                access.addRole(role);
            }
        }
        if (token.getResourceAccess() == null || token.getResourceAccess().size() == 0) {
            return null;
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="{realm}/auth/request/login")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response login(@PathParam(value="realm") String realmName, MultivaluedMap<String, String> formData) {
        String clientId = (String)formData.getFirst((Object)"client_id");
        String scopeParam = (String)formData.getFirst((Object)"scope");
        String state = (String)formData.getFirst((Object)"state");
        String redirect = (String)formData.getFirst((Object)"redirect_uri");
        Realm realm = this.identityManager.getRealm(realmName);
        if (realm == null) {
            this.logger.debug("realm not found");
            throw new NotFoundException();
        }
        if (!realm.isEnabled()) {
            return Response.ok((Object)"Realm not enabled").type("text/html").build();
        }
        User client = this.identityManager.getUser(realm, clientId);
        if (client == null) {
            this.logger.debug("client not found");
            throw new ForbiddenException();
        }
        if (!client.isEnabled()) {
            return Response.ok((Object)"Requester not enabled").type("text/html").build();
        }
        String username = (String)formData.getFirst((Object)"username");
        User user = this.identityManager.getUser(realm, username);
        if (user == null) {
            this.logger.debug("user not found");
            return this.loginForm("Not valid user", redirect, clientId, scopeParam, state, realm, client);
        }
        if (!user.isEnabled()) {
            return Response.ok((Object)"Your account is not enabled").type("text/html").build();
        }
        boolean authenticated = this.authenticate(realm, user, formData);
        if (!authenticated) {
            return this.loginForm("Unable to authenticate, try again", redirect, clientId, scopeParam, state, realm, client);
        }
        SkeletonKeyToken token = this.createToken(scopeParam, realm, client, user);
        AccessCode code = new AccessCode();
        code.setExpiration(System.currentTimeMillis() / 1000L + realm.getAccessCodeLifespan());
        code.setToken(token);
        code.setClient(client);
        Map<String, AccessCode> map = this.accessCodeMap;
        synchronized (map) {
            this.accessCodeMap.put(code.getId(), code);
        }
        String accessCode = null;
        try {
            accessCode = new JWSBuilder().content(code.getId().getBytes("UTF-8")).rsa256(realm.getPrivateKey());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        UriBuilder redirectUri = UriBuilder.fromUri((String)redirect).queryParam("code", new Object[]{accessCode});
        if (state != null) {
            redirectUri.queryParam("state", new Object[]{state});
        }
        return Response.status((int)302).location(redirectUri.build(new Object[0])).build();
    }

    protected SkeletonKeyToken createToken(String scopeParam, Realm realm, User client, User user) {
        SkeletonKeyToken token = null;
        if (scopeParam != null) {
            token = new SkeletonKeyToken();
            token.id(TokenManagement.generateId());
            token.principal(user.getUsername());
            token.audience(realm.getName());
            if (realm.getTokenLifespan() > 0L) {
                token.expiration(System.currentTimeMillis() / 1000L + realm.getTokenLifespan());
            }
            SkeletonKeyScope scope = null;
            byte[] bytes = Base64Url.decode((String)scopeParam);
            try {
                scope = (SkeletonKeyScope)JsonSerialization.fromBytes(SkeletonKeyScope.class, (byte[])bytes);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            for (String res : scope.keySet()) {
                Resource resource = this.identityManager.getResource(realm, res);
                ScopeMapping scopeMapping = this.identityManager.getScopeMapping(realm, resource, client);
                RoleMapping roleMapping = this.identityManager.getRoleMapping(realm, resource, user);
                SkeletonKeyToken.Access access = token.addAccess(resource.getName());
                for (String role : scope.get((Object)res)) {
                    if (!scopeMapping.getRoles().contains(role)) {
                        throw new ForbiddenException(Response.status((int)403).entity((Object)"<h1>Security Alert</h1><p>Known client not authorized for the requested scope.</p>").type("text/html").build());
                    }
                    if (!roleMapping.getRoles().contains(role)) {
                        throw new ForbiddenException(Response.status((int)403).entity((Object)"<h1>Security Alert</h1><p>You are not authorized for the requested scope.</p>").type("text/html").build());
                    }
                    access.addRole(role);
                    if (roleMapping.getSurrogateIds() == null || roleMapping.getSurrogateIds().size() <= 0) continue;
                    throw new NotImplementedYetException();
                }
            }
        } else {
            ScopeMapping mapping = this.identityManager.getScopeMapping(realm, client);
            if (mapping == null || !mapping.getRoles().contains("login")) {
                throw new ForbiddenException(Response.status((int)403).entity((Object)"<h1>Security Alert</h1><p>Known client not authorized to request a user login.</p>").type("text/html").build());
            }
            token = this.createAccessToken(user, realm);
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="{realm}/access/codes")
    @POST
    @Produces(value={"application/json"})
    public Response accessRequest(@PathParam(value="realm") String realmId, MultivaluedMap<String, String> formData) {
        AccessTokenResponse res;
        Realm realm = this.identityManager.getRealm(realmId);
        if (realm == null) {
            throw new NotFoundException();
        }
        String code = (String)formData.getFirst((Object)"code");
        if (code == null) {
            this.logger.debug("code not specified");
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("error", "invalid_request");
            error.put("error_description", "code not specified");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(error).type("application/json").build();
        }
        String client_id = (String)formData.getFirst((Object)"client_id");
        if (client_id == null) {
            this.logger.debug("client_id not specified");
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("error", "invalid_request");
            error.put("error_description", "client_id not specified");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(error).type("application/json").build();
        }
        User client = this.identityManager.getUser(realm, client_id);
        if (client == null) {
            this.logger.debug("Could not find user");
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("error", "invalid_client");
            error.put("error_description", "Could not find user");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(error).type("application/json").build();
        }
        if (!client.isEnabled()) {
            this.logger.debug("user is not enabled");
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("error", "invalid_client");
            error.put("error_description", "User is not enabled");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(error).type("application/json").build();
        }
        boolean authenticated = this.authenticate(realm, client, formData);
        if (!authenticated) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("error", "unauthorized_client");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(error).type("application/json").build();
        }
        JWSInput input = new JWSInput(code, this.providers);
        boolean verifiedCode = false;
        try {
            verifiedCode = RSAProvider.verify((JWSInput)input, (PublicKey)realm.getPublicKey());
        }
        catch (Exception ignored) {
            this.logger.debug("Failed to verify signature", (Throwable)ignored);
        }
        if (!verifiedCode) {
            HashMap<String, String> res2 = new HashMap<String, String>();
            res2.put("error", "invalid_grant");
            res2.put("error_description", "Unable to verify code signature");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity(res2).build();
        }
        String key = (String)input.readContent(String.class);
        AccessCode accessCode = null;
        Map<String, AccessCode> map = this.accessCodeMap;
        synchronized (map) {
            accessCode = this.accessCodeMap.remove(key);
        }
        if (accessCode == null) {
            res = new HashMap();
            res.put("error", "invalid_grant");
            res.put("error_description", "Code not found");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity(res).build();
        }
        if (accessCode.isExpired()) {
            res = new HashMap();
            res.put("error", "invalid_grant");
            res.put("error_description", "Code is expired");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)res).build();
        }
        if (!accessCode.getToken().isActive()) {
            res = new HashMap();
            res.put("error", "invalid_grant");
            res.put("error_description", "Token expired");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)res).build();
        }
        if (!client.getId().equals(accessCode.getClient().getId())) {
            res = new HashMap();
            res.put("error", "invalid_grant");
            res.put("error_description", "Auth error");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)res).build();
        }
        res = this.accessTokenResponse(realm.getPrivateKey(), accessCode.getToken());
        return Response.ok((Object)res).build();
    }

    protected AccessTokenResponse accessTokenResponse(PrivateKey privateKey, SkeletonKeyToken token) {
        byte[] tokenBytes = null;
        try {
            tokenBytes = JsonSerialization.toByteArray((Object)token, (boolean)false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String encodedToken = new JWSBuilder().content(tokenBytes).rsa256(privateKey);
        AccessTokenResponse res = new AccessTokenResponse();
        res.setToken(encodedToken);
        res.setTokenType("bearer");
        if (token.getExpiration() != 0L) {
            long time = token.getExpiration() - System.currentTimeMillis() / 1000L;
            res.setExpiresIn(time);
        }
        return res;
    }

    @Path(value="{realm}/auth/request")
    @GET
    public Response requestAccessCode(@PathParam(value="realm") String realmName, @QueryParam(value="response_type") String responseType, @QueryParam(value="redirect_uri") String redirect, @QueryParam(value="client_id") String clientId, @QueryParam(value="scope") String scopeParam, @QueryParam(value="state") String state) {
        Realm realm = this.identityManager.getRealm(realmName);
        if (realm == null) {
            throw new NotFoundException();
        }
        User client = this.identityManager.getUser(realm, clientId);
        if (client == null) {
            return Response.ok((Object)"<h1>Security Alert</h1><p>Unknown client trying to get access to your account.</p>").type("text/html").build();
        }
        return this.loginForm(null, redirect, clientId, scopeParam, state, realm, client);
    }

    private Response loginForm(String validationError, String redirect, String clientId, String scopeParam, String state, Realm realm, User client) {
        StringBuffer html = new StringBuffer();
        if (scopeParam != null) {
            html.append("<h1>Grant Request For ").append(realm.getName()).append(" Realm</h1>");
            if (validationError != null) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                html.append("<p/><p><b>").append(validationError).append("</b></p>");
            }
            html.append("<p>A Third Party is requesting access to the following resources</p>");
            html.append("<table>");
            SkeletonKeyScope scope = null;
            byte[] bytes = Base64Url.decode((String)scopeParam);
            try {
                scope = (SkeletonKeyScope)JsonSerialization.fromBytes(SkeletonKeyScope.class, (byte[])bytes);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            for (String res : scope.keySet()) {
                Resource resource = this.identityManager.getResource(realm, res);
                html.append("<tr><td><b>Resource: </b>").append(resource.getName()).append("</td><td><b>Roles:</b>");
                ScopeMapping mapping = this.identityManager.getScopeMapping(realm, resource, client);
                for (String role : scope.get((Object)res)) {
                    html.append(" ").append(role);
                    if (mapping.getRoles().contains(role)) continue;
                    return Response.ok((Object)"<h1>Security Alert</h1><p>Known client not authorized for the requested scope.</p>").type("text/html").build();
                }
                html.append("</td></tr>");
            }
            html.append("</table><p>To Authorize, please login below</p>");
        } else {
            ScopeMapping mapping = this.identityManager.getScopeMapping(realm, client);
            if (mapping != null && mapping.getRoles().contains("login")) {
                html.append("<h1>Login For ").append(realm.getName()).append(" Realm</h1>");
                if (validationError != null) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    html.append("<p/><p><b>").append(validationError).append("</b></p>");
                }
            } else {
                html.append("<h1>Grant Request For ").append(realm.getName()).append(" Realm</h1>");
                if (validationError != null) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    html.append("<p/><p><b>").append(validationError).append("</b></p>");
                }
                SkeletonKeyScope scope = new SkeletonKeyScope();
                List<Resource> resources = this.identityManager.getResources(realm);
                boolean found = false;
                for (Resource resource : resources) {
                    ScopeMapping resourceScope = this.identityManager.getScopeMapping(realm, resource, client);
                    if (resourceScope == null || resourceScope.getRoles().size() == 0) continue;
                    if (!found) {
                        found = true;
                        html.append("<p>A Third Party is requesting access to the following resources</p>");
                        html.append("<table>");
                    }
                    html.append("<tr><td><b>Resource: </b>").append(resource.getName()).append("</td><td><b>Roles:</b>");
                    for (String role : resourceScope.getRoles()) {
                        html.append(" ").append(role);
                        scope.add((Object)resource.getName(), (Object)role);
                    }
                }
                if (!found) {
                    return Response.ok((Object)"<h1>Security Alert</h1><p>Known client not authorized to access this realm.</p>").type("text/html").build();
                }
                html.append("</table>");
                try {
                    String json = JsonSerialization.toString((Object)scope, (boolean)false);
                    scopeParam = Base64Url.encode((byte[])json.getBytes("UTF-8"));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        UriBuilder formActionUri = this.uriInfo.getBaseUriBuilder().path(TokenManagement.class).path(TokenManagement.class, "login");
        String action = formActionUri.build(new Object[]{realm.getId()}).toString();
        html.append("<form action=\"").append(action).append("\" method=\"POST\">");
        html.append("Username: <input type=\"text\" name=\"username\" size=\"20\"><br>");
        for (RequiredCredential credential : this.identityManager.getRequiredCredentials(realm)) {
            if (!credential.isInput()) continue;
            html.append(credential.getType()).append(": ");
            if (credential.isSecret()) {
                html.append("<input type=\"password\" name=\"").append(credential.getType()).append("\"  size=\"20\"><br>");
                continue;
            }
            html.append("<input type=\"text\" name=\"").append(credential.getType()).append("\"  size=\"20\"><br>");
        }
        html.append("<input type=\"hidden\" name=\"client_id\" value=\"").append(clientId).append("\">");
        if (scopeParam != null) {
            html.append("<input type=\"hidden\" name=\"scope\" value=\"").append(scopeParam).append("\">");
        }
        if (state != null) {
            html.append("<input type=\"hidden\" name=\"state\" value=\"").append(state).append("\">");
        }
        html.append("<input type=\"hidden\" name=\"redirect_uri\" value=\"").append(redirect).append("\">");
        html.append("<input type=\"submit\" value=\"");
        if (scopeParam == null) {
            html.append("Login");
        } else {
            html.append("Grant Access");
        }
        html.append("\">");
        html.append("</form>");
        return Response.ok((Object)html.toString()).type("text/html").build();
    }

    @Path(value="{realm}/grants")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public Response accessTokenGrant(@PathParam(value="realm") String realmId, MultivaluedMap<String, String> formParams) {
        Realm realm = this.identityManager.getRealm(realmId);
        if (realm == null) {
            throw new NotFoundException();
        }
        if (!realm.isEnabled()) {
            this.logger.debug("realm is not enabled");
            throw new NotFoundException();
        }
        User user = this.identityManager.getUser(realm, (String)formParams.getFirst((Object)"client_id"));
        if (user == null) {
            this.logger.debug("Could not find user");
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("error", "invalid_client");
            error.put("error_description", "Could not find user");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(error).type("application/json").build();
        }
        if (!user.isEnabled()) {
            this.logger.debug("user is not enabled");
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("error", "invalid_client");
            error.put("error_description", "User is not enabled");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(error).type("application/json").build();
        }
        boolean authenticated = this.authenticate(realm, user, formParams);
        if (!authenticated) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("error", "unauthorized_client");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(error).type("application/json").build();
        }
        SkeletonKeyToken token = this.createAccessToken(user, realm);
        if (token == null) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("error", "unauthorized_client");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(error).type("application/json").build();
        }
        return Response.ok((Object)this.accessTokenResponse(realm.getPrivateKey(), token), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
    }

    protected boolean authenticate(Realm realm, User user, MultivaluedMap<String, String> formData) {
        MultivaluedHashMap userCredentials = new MultivaluedHashMap();
        List<UserCredential> creds = this.identityManager.getCredentials(user);
        for (UserCredential userCredential : creds) {
            userCredentials.add((Object)userCredential.getType(), (Object)userCredential);
        }
        for (RequiredCredential credential : this.identityManager.getRequiredCredentials(realm)) {
            if (credential.isInput()) {
                String value = (String)formData.getFirst((Object)credential.getType());
                if (value == null) {
                    return false;
                }
                UserCredential userCredential = (UserCredential)userCredentials.getFirst((Object)credential.getType());
                if (userCredential == null) {
                    this.logger.warn("Missing required user credential");
                    return false;
                }
                if (userCredential.isHashed()) {
                    value = this.hash(value);
                }
                if (value.equals(userCredential.getValue())) continue;
                this.logger.warn("Credential mismatch");
                return false;
            }
            if (credential.getType().equals("CALLER_PRINCIPAL")) {
                List principals = (List)userCredentials.get((Object)"CALLER_PRINCIPAL");
                if (principals == null) {
                    return false;
                }
                boolean found = false;
                for (UserCredential userCredential : principals) {
                    if (!userCredential.getValue().equals(this.securityContext.getUserPrincipal().getName())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                this.logger.warn("caller principal not matched");
                return false;
            }
            throw new NotImplementedYetException();
        }
        return true;
    }

    private String hash(String value) {
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        byte[] bytes = digest.digest(value.getBytes());
        return Base64.encodeBytes((byte[])bytes);
    }

    public static class AccessCode {
        protected String id = UUID.randomUUID().toString() + System.currentTimeMillis();
        protected long expiration;
        protected SkeletonKeyToken token;
        protected User client;

        public boolean isExpired() {
            return this.expiration != 0L && System.currentTimeMillis() / 1000L > this.expiration;
        }

        public String getId() {
            return this.id;
        }

        public long getExpiration() {
            return this.expiration;
        }

        public void setExpiration(long expiration) {
            this.expiration = expiration;
        }

        public SkeletonKeyToken getToken() {
            return this.token;
        }

        public void setToken(SkeletonKeyToken token) {
            this.token = token;
        }

        public User getClient() {
            return this.client;
        }

        public void setClient(User client) {
            this.client = client;
        }
    }
}

