/*
 * Decompiled with CFR 0.152.
 */
package Acme.Serve;

import Acme.Serve.Serve;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Map;

public class SimpleAcceptor
implements Serve.Acceptor {
    private ServerSocket socket;

    @Override
    public Socket accept() throws IOException {
        return this.socket.accept();
    }

    @Override
    public void destroy() throws IOException {
        this.socket.close();
    }

    @Override
    public void init(Map<Object, Object> inProperties, Map<Object, Object> outProperties) throws IOException {
        int backlog;
        int port = inProperties.get("port") != null ? (Integer)inProperties.get("port") : 8080;
        String bindAddrStr = (String)inProperties.get("bind-address");
        InetSocketAddress bindAddr = bindAddrStr != null ? new InetSocketAddress(InetAddress.getByName(bindAddrStr), port) : null;
        String backlogStr = (String)inProperties.get("backlog");
        int n = backlog = backlogStr != null ? Integer.parseInt(backlogStr) : -1;
        if (bindAddr != null) {
            this.socket = new ServerSocket();
            if (backlog < 0) {
                this.socket.bind(bindAddr);
            } else {
                this.socket.bind(bindAddr, backlog);
            }
        } else {
            this.socket = backlog < 0 ? new ServerSocket(port) : new ServerSocket(port, backlog);
        }
        if (outProperties != null) {
            if (this.socket.isBound()) {
                outProperties.put("bind-address", this.socket.getInetAddress().getHostName());
            } else {
                outProperties.put("bind-address", InetAddress.getLocalHost().getHostName());
            }
        }
    }

    public String toString() {
        return "SimpleAcceptor " + this.socket;
    }
}

