/*
 * Decompiled with CFR 0.152.
 */
package Acme.Serve;

import Acme.Serve.Serve;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.util.Iterator;
import java.util.Map;

public class SelectorAcceptor
implements Serve.Acceptor {
    private ServerSocketChannel channel;
    private Selector selector;
    private Iterator readyItor;

    @Override
    public Socket accept() throws IOException {
        while (true) {
            if (this.readyItor == null) {
                if (this.selector.select() > 0) {
                    this.readyItor = this.selector.selectedKeys().iterator();
                } else {
                    throw new IOException();
                }
            }
            if (this.readyItor.hasNext()) {
                SelectionKey key = (SelectionKey)this.readyItor.next();
                this.readyItor.remove();
                if (!key.isValid() || !key.isAcceptable()) continue;
                ServerSocketChannel keyChannel = (ServerSocketChannel)key.channel();
                ServerSocket serverSocket = keyChannel.socket();
                return serverSocket.accept();
            }
            this.readyItor = null;
        }
    }

    @Override
    public void destroy() throws IOException {
        String exceptions = "";
        try {
            this.channel.close();
        }
        catch (IOException e) {
            exceptions = exceptions + e.toString();
        }
        try {
            this.selector.close();
        }
        catch (IOException e) {
            exceptions = exceptions + e.toString();
        }
        if (exceptions.length() > 0) {
            throw new IOException(exceptions);
        }
    }

    @Override
    public void init(Map inProperties, Map outProperties) throws IOException {
        this.selector = Selector.open();
        this.channel = ServerSocketChannel.open();
        this.channel.configureBlocking(false);
        int port = inProperties.get("port") != null ? (Integer)inProperties.get("port") : 8080;
        InetSocketAddress isa = null;
        if (inProperties.get("bind-address") != null) {
            try {
                isa = new InetSocketAddress((String)inProperties.get("bind-address"), port);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (isa == null) {
            isa = new InetSocketAddress(port);
        }
        this.channel.socket().bind(isa);
        this.channel.register(this.selector, 16);
        if (outProperties != null) {
            if (this.channel.socket().isBound()) {
                outProperties.put("bind-address", this.channel.socket().getInetAddress().getHostName());
            } else {
                outProperties.put("bind-address", InetAddress.getLocalHost().getHostName());
            }
        }
    }

    public String toString() {
        return "SelectorAcceptor - " + (this.channel == null ? "unset" : "" + this.channel.socket());
    }
}

