/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.scanning.plugins.visitor;

import org.jboss.classloading.spi.visitor.ResourceContext;
import org.jboss.classloading.spi.visitor.ResourceVisitor;
import org.jboss.logging.Logger;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.scanning.plugins.visitor.ReflectProvider;

public abstract class ReflectResourceVisitor
implements ResourceVisitor {
    protected final Logger log = Logger.getLogger(this.getClass());
    private ReflectProvider provider;
    protected boolean ignoreError;

    protected ReflectResourceVisitor(ReflectProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Null provider");
        }
        this.provider = provider;
    }

    protected TypeInfo getTypeInfo(ResourceContext resource) throws Throwable {
        return this.provider.getTypeInfo(resource);
    }

    protected ClassInfo getClassInfo(ResourceContext resource) throws Throwable {
        TypeInfo typeInfo = this.getTypeInfo(resource);
        if (!(typeInfo instanceof ClassInfo)) {
            throw new IllegalArgumentException("Can only handle class info: " + typeInfo);
        }
        return (ClassInfo)ClassInfo.class.cast(typeInfo);
    }

    public void visit(ResourceContext resource) {
        if (!resource.isClass()) {
            return;
        }
        try {
            this.doVisit(resource);
        }
        catch (Throwable t) {
            if (this.ignoreError) {
                this.logThrowable(resource, t);
            }
            throw new RuntimeException(t);
        }
    }

    protected void doVisit(ResourceContext resource) throws Throwable {
        ClassInfo classInfo = this.getClassInfo(resource);
        this.handleClass(resource, classInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleClass(ResourceContext resource, ClassInfo classInfo) throws Exception {
        classInfo.setAttachment(ResourceContext.class.getName(), (Object)resource);
        try {
            this.handleClass(classInfo);
        }
        finally {
            classInfo.setAttachment(ResourceContext.class.getName(), null);
        }
    }

    protected void handleClass(ClassInfo classInfo) throws Exception {
    }

    protected void logThrowable(ResourceContext resource, Throwable t) {
        t.printStackTrace();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Exception reading resource: " + resource.getResourceName()), t);
        }
    }

    public void setIgnoreError(boolean ignoreError) {
        this.ignoreError = ignoreError;
    }
}

