/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.scanning.plugins;

import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.scanning.spi.ScanningHandle;
import org.jboss.scanning.spi.ScanningPlugin;

/**
 * Deployment based scanning plugin factory.
 * Used for incallback automatching.
 *
 * @param <T> exact handle type
 * @param <U> exact attachment type
 * @author <a href="mailto:ales.justin@jboss.org">Ales Justin</a>
 */
public interface DeploymentScanningPluginFactory<T extends ScanningHandle, U>
{
   /**
    * Is this plugin relevant to unit.
    *
    * @param unit the unit to check against
    * @return true if it's relevant, false otherwise
    */
   boolean isRelevant(DeploymentUnit unit);

   /**
    * Get plugin's output.
    *
    * Can be null, if it cannot be determined before actual plugin creation
    * or the plugin actually doesn't create any attachment.
    *
    * @return plugin's output
    */
   String getPluginOutput();

   /**
    * Create scanning plugin from deployment unit.
    *
    * @param unit the deployment unit
    * @return new scanning plugin
    */
   ScanningPlugin<T, U> create(DeploymentUnit unit);
}
