/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.scanning.plugins;

import java.net.URL;

import org.jboss.scanning.spi.helpers.UrlScanner;
import org.jboss.vfs.VFS;

/**
 * VFS url scanner.
 *
 * @author <a href="mailto:ales.justin@jboss.org">Ales Justin</a>
 */
public abstract class VFSUrlScanner extends UrlScanner
{
   private boolean toVFS;

   public VFSUrlScanner(URL... roots)
   {
      super(roots);
   }

   /**
    * Change non-VFS url to VFS urls.
    *
    * @param urls the urls to transform
    * @return new vfs based urls
    * @throws Exception for any error
    */
   protected static URL[] toVFS(URL[] urls) throws Exception
   {
      URL[] vfs = new URL[urls.length];
      for (int i = 0; i < urls.length; i++)
         vfs[i] = VFS.getChild(urls[i]).toURL();
      return vfs;
   }

   public boolean isToVFS()
   {
      return toVFS;
   }

   public void setToVFS(boolean toVFS)
   {
      this.toVFS = toVFS;
   }
}