/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.scanning.plugins.filter;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.classloading.spi.visitor.ResourceContext;
import org.jboss.classloading.spi.visitor.ResourceFilter;
import org.jboss.scanning.spi.metadata.PathEntryMetaData;
import org.jboss.scanning.spi.metadata.PathMetaData;
import org.jboss.scanning.spi.metadata.ScanningMetaData;
import org.jboss.vfs.util.PathTokenizer;

public class ScanningMetaDataRecurseFilter
implements ResourceFilter {
    private Map<String, RootNode> roots;
    private boolean allExcluded;

    public ScanningMetaDataRecurseFilter(ScanningMetaData smd) {
        if (smd == null) {
            throw new IllegalArgumentException("Null metadata");
        }
        List paths = smd.getPaths();
        if (paths != null && !paths.isEmpty()) {
            this.allExcluded = true;
            this.roots = new HashMap<String, RootNode>();
            for (PathMetaData pmd : paths) {
                RootNode pathNode = new RootNode();
                this.roots.put(pmd.getPathName(), pathNode);
                pathNode.excluded = pmd.isExcluded();
                if (pathNode.excluded) continue;
                this.allExcluded = false;
                Set includes = pmd.getIncludes();
                if (includes == null || includes.isEmpty()) continue;
                pathNode.explicitInclude = true;
                for (PathEntryMetaData pemd : includes) {
                    String name = pemd.getName();
                    String[] tokens = name.split("\\.");
                    Node current = pathNode;
                    for (String token : tokens) {
                        current = current.addChild(token);
                    }
                    if (!pemd.isRecurse()) continue;
                    current.recurse = true;
                }
            }
        }
    }

    public boolean accepts(ResourceContext resource) {
        if (this.roots == null) {
            return false;
        }
        URL url = resource.getUrl();
        String urlString = url.toExternalForm();
        for (Map.Entry<String, RootNode> root : this.roots.entrySet()) {
            if (!urlString.contains(root.getKey())) continue;
            RootNode rootNode = root.getValue();
            if (rootNode.excluded) {
                return false;
            }
            if (rootNode.explicitInclude) {
                String resourceName = resource.getResourceName();
                List tokens = PathTokenizer.getTokens((String)resourceName);
                Node current = rootNode;
                for (String token : tokens) {
                    if (current.recurse) break;
                    if ((current = current.getChild(token)) != null) continue;
                    return false;
                }
            }
            return true;
        }
        return this.allExcluded;
    }

    private static class RootNode
    extends Node {
        private boolean excluded;
        private boolean explicitInclude;

        private RootNode() {
        }
    }

    private static class Node {
        private Map<String, Node> children;
        private boolean recurse;

        private Node() {
        }

        public Node addChild(String value) {
            Node child;
            if (this.children == null) {
                this.children = new HashMap<String, Node>();
            }
            if ((child = this.children.get(value)) == null) {
                child = new Node();
                this.children.put(value, child);
            }
            return child;
        }

        public Node getChild(String child) {
            return this.children != null ? this.children.get(child) : null;
        }
    }
}

