/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.scanning.plugins.helpers;

import java.util.Map;
import java.util.Set;

/**
 * Help merge handles.
 *
 * @author <a href="mailto:ales.justin@jboss.org">Ales Justin</a>
 */
public class MergeUtils
{
   /**
    * Merge double level maps.
    *
    * @param dest the destination
    * @param src the source
    */
   public static <T, U, V> void doubleMerge(Map<T, Map<U, Set<V>>> dest, Map<T, Map<U, Set<V>>> src)
   {
      if (dest == null)
         throw new IllegalArgumentException("Null dest");
      if (src == null)
         return;

      for (Map.Entry<T, Map<U, Set<V>>> entry : src.entrySet())
      {
         Map<U, Set<V>> dVal = dest.get(entry.getKey());
         if (dVal != null)
         {
            Map<U, Set<V>> sVal = entry.getValue();
            singleMerge(dVal, sVal);
         }
         else
         {
            dest.put(entry.getKey(), entry.getValue());
         }
      }
   }

   /**
    * Merge single level maps.
    *
    * @param dest the destination
    * @param src the source
    */
   public static <U, V> void singleMerge(Map<U, Set<V>> dest, Map<U, Set<V>> src)
   {
      if (dest == null)
         throw new IllegalArgumentException("Null dest");
      if (src == null)
         return;

      for (Map.Entry<U, Set<V>> entry : src.entrySet())
      {
         Set<V> dSet = dest.get(entry.getKey());
         if (dSet != null)
         {
            dSet.addAll(entry.getValue());
         }
         else
         {
            dest.put(entry.getKey(), entry.getValue());
         }
      }
   }
}
