/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.scanning.indexer;

import java.io.File;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.jboss.scanning.indexer.core.ScanUtils;

/**
 * The Scanning Indexer.
 *
 * @author <a href="mailto:jesper.pedersen@jboss.org">Jesper Pedersen</a>
 * @author <a href="mailto:ales.justin@jboss.org">Ales Justin</a>
 */
public class Main
{
   private static final Logger log = Logger.getLogger(Main.class.getName());

   /**
    * Usage
    */
   private static void usage()
   {
      System.out.println("Usage: Indexer <input-jar> <scanning-plugins-comma-delimited> <classpath*>");
   }

   /**
    * Main.
    * The output is file named <input-jar>.jar.mcs.
    *
    * @param args the program arguments
    */
   public static void main(String[] args)
   {
      try
      {
         int offset = 2;
         if (args.length < offset)
         {
            File input = new File(args[0]);
            String[] providers = args[1].split(",");
            URL[] urls = new URL[args.length - offset];
            // add the rest of classpath
            for (int i = 0; i < urls.length; i++)
               urls[i] = new File(args[i + offset]).toURI().toURL();

            ScanUtils.scan(input, Constants.applyAliases(providers), urls);
         }
         else
         {
            usage();
         }
      }
      catch (Throwable t)
      {
         log.log(Level.SEVERE, t.getMessage(), t);
      }
   }
}
