/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.scanning.indexer;

import java.util.*;

/**
 * @author <a href="mailto:ales.justin@jboss.org">Ales Justin</a>
 */
public class Constants
{
   /** Alias to plugin (provider) shortcut */
   private static final Map<String, String> aliases = new HashMap<String, String>();

   static
   {
      aliases.put("@", "org.jboss.scanning.annotations.plugins.AnnotationsScanningPlugin");
      aliases.put("ann", "org.jboss.scanning.annotations.plugins.AnnotationsScanningPlugin");
      aliases.put("annotations", "org.jboss.scanning.annotations.plugins.AnnotationsScanningPlugin");
      aliases.put("h", "org.jboss.scanning.hierarchy.plugins.HierarchyIndexScanningPlugin");
      aliases.put("hierarchy", "org.jboss.scanning.hierarchy.plugins.HierarchyIndexScanningPlugin");
   }

   /**
    * Apply alias.
    *
    * @param key the key
    * @return return alias if found, else return key
    */
   public static String applyAlias(String key)
   {
      String value = aliases.get(key);
      return value != null ? value : key;
   }

   /**
    * Apply aliases.
    *
    * @param providers the providers
    * @return set of providers with applied aliases
    */
   public static Set<String> applyAliases(String... providers)
   {
      if (providers == null)
         return Collections.emptySet();
      
      Set<String> set = new HashSet<String>();
      for (String provider : providers)
         set.add(applyAlias(provider));
      return set;
   }
}
