/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.scanning.indexer.core;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.Logger;
import java.util.zip.ZipOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtil {
    private static Logger log = Logger.getLogger(FileUtil.class.getName());

    private FileUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compress(File directory, File target) throws IOException {
        if (directory == null) {
            throw new IllegalArgumentException("Directory is null");
        }
        if (target == null) {
            throw new IllegalArgumentException("Target is null");
        }
        if (target.exists()) {
            FileUtil.recursiveDelete(target);
        }
        Manifest manifest = null;
        File manifestFile = new File(directory, "META-INF/MANIFEST.MF");
        if (manifestFile.exists()) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(manifestFile);
                manifest = new Manifest(fis);
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException ignore) {}
            }
        }
        log.fine("No META-INF/MANIFEST.MF found; creating one");
        manifest = new Manifest();
        ZipOutputStream jos = null;
        try {
            FileOutputStream fos = new FileOutputStream(target);
            jos = new JarOutputStream((OutputStream)fos, manifest);
            byte[] buffer = new byte[4096];
            List<File> entries = FileUtil.findEntries(directory);
            if (entries != null) {
                entries.remove(new File("META-INF/MANIFEST.MF"));
                for (File file : entries) {
                    File f = new File(directory, file.getPath());
                    JarEntry entry = new JarEntry(file.getPath());
                    ((JarOutputStream)jos).putNextEntry(entry);
                    FileInputStream in = null;
                    try {
                        int bytesRead;
                        in = new FileInputStream(f);
                        while ((bytesRead = in.read(buffer)) != -1) {
                            jos.write(buffer, 0, bytesRead);
                        }
                    }
                    finally {
                        if (in == null) continue;
                        try {
                            in.close();
                        }
                        catch (IOException ioe) {}
                    }
                }
            }
            jos.flush();
        }
        finally {
            try {
                if (jos != null) {
                    jos.close();
                }
            }
            catch (IOException ignore) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File extract(File file, File directory) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("File is null");
        }
        if (directory == null) {
            throw new IllegalArgumentException("Directory is null");
        }
        File target = new File(directory, file.getName());
        if (target.exists()) {
            FileUtil.recursiveDelete(target);
        }
        if (!target.mkdirs()) {
            throw new IOException("Could not create " + target);
        }
        JarFile jar = new JarFile(file);
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry je = entries.nextElement();
            File copy = new File(target, je.getName());
            if (!je.isDirectory()) {
                BufferedInputStream in = null;
                OutputStream out = null;
                if (copy.getParentFile() != null && !copy.getParentFile().exists() && !copy.getParentFile().mkdirs()) {
                    throw new IOException("Could not create " + copy.getParentFile());
                }
                try {
                    int nBytes;
                    in = new BufferedInputStream(jar.getInputStream(je));
                    out = new BufferedOutputStream(new FileOutputStream(copy));
                    byte[] buffer = new byte[4096];
                    while ((nBytes = ((InputStream)in).read(buffer)) > 0) {
                        out.write(buffer, 0, nBytes);
                    }
                    out.flush();
                    continue;
                }
                finally {
                    try {
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (IOException ignore) {}
                    try {
                        if (in == null) continue;
                        ((InputStream)in).close();
                    }
                    catch (IOException ignore) {}
                    continue;
                }
            }
            if (!copy.exists()) {
                if (copy.mkdirs()) continue;
                throw new IOException("Could not create " + copy);
            }
            if (copy.isDirectory()) continue;
            throw new IOException(copy + " isn't a directory");
        }
        jar.close();
        return target;
    }

    public static void recursiveDelete(File f) throws IOException {
        if (f != null && f.exists()) {
            File[] files = f.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (file.isDirectory()) {
                        FileUtil.recursiveDelete(file);
                        continue;
                    }
                    if (file.delete()) continue;
                    throw new IOException("Could not delete " + file);
                }
            }
            if (!f.delete()) {
                throw new IOException("Could not delete " + f);
            }
        }
    }

    private static List<File> findEntries(File root) {
        try {
            return FileUtil.getListing(root, root);
        }
        catch (Exception e) {
            log.severe(e.getMessage());
            return null;
        }
    }

    private static List<File> getListing(File root, File directory) throws Exception {
        ArrayList<File> result = new ArrayList<File>();
        File[] filesAndDirs = directory.listFiles();
        if (filesAndDirs != null) {
            for (File file : filesAndDirs) {
                if (file.isDirectory()) {
                    List<File> deeperList = FileUtil.getListing(root, file);
                    result.addAll(deeperList);
                    continue;
                }
                String fileName = file.getPath().substring(root.getPath().length() + 1);
                result.add(new File(fileName));
            }
        }
        return result;
    }
}

