/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.scanning.indexer.core;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.scanning.indexer.core.FileUtil;
import org.jboss.scanning.indexer.core.PluginProvider;
import org.jboss.scanning.plugins.DefaultScanner;
import org.jboss.scanning.spi.ScanningHandle;
import org.jboss.scanning.spi.ScanningPlugin;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.util.automount.Automounter;
import org.jboss.vfs.util.automount.MountOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScanUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File scan(File input, Set<String> pluginProviders, URL ... cp) throws Exception {
        if (input == null) {
            throw new IllegalArgumentException("Null input");
        }
        if (pluginProviders == null || pluginProviders.isEmpty()) {
            throw new IllegalArgumentException("Null or empty providers");
        }
        if (cp == null) {
            cp = new URL[]{};
        }
        URL root = input.toURI().toURL();
        URL[] urls = new URL[cp.length + 1];
        urls[0] = root;
        System.arraycopy(cp, 0, urls, 1, cp.length);
        URLClassLoader ucl = new URLClassLoader(urls, ScanUtils.class.getClassLoader());
        HashSet<ScanningPlugin> plugins = new HashSet<ScanningPlugin>();
        for (String provider : pluginProviders) {
            plugins.add(ScanUtils.createPlugin(provider, ucl));
        }
        DefaultScanner scaner = new DefaultScanner((ClassLoader)ucl, new URL[]{root});
        scaner.setPlugins(plugins);
        scaner.setIgnoreIndexedHandles(true);
        VirtualFile vfs = VFS.getChild((URL)root);
        Automounter.mount((VirtualFile)vfs, (MountOption[])new MountOption[0]);
        try {
            scaner.scan();
        }
        finally {
            Automounter.cleanup((VirtualFile)vfs);
        }
        Map handles = scaner.getHandles();
        File tmp = new File(System.getProperty("java.io.tmpdir"));
        File jar = FileUtil.extract(input, tmp);
        try {
            File destination = new File(jar, "META-INF/");
            ScanUtils.store(destination, handles);
            File output = new File(input.getParent(), input.getName() + ".mcs");
            FileUtil.compress(jar, output);
            File file = output;
            return file;
        }
        finally {
            FileUtil.recursiveDelete(jar);
        }
    }

    protected static ScanningPlugin createPlugin(String provider, URLClassLoader ucl) throws Exception {
        Class<?> clazz = ucl.loadClass(provider);
        if (ScanningPlugin.class.isAssignableFrom(clazz)) {
            try {
                return (ScanningPlugin)clazz.newInstance();
            }
            catch (Exception e) {
                Constructor<?> ctor = clazz.getDeclaredConstructor(ClassLoader.class);
                return (ScanningPlugin)ctor.newInstance(ucl);
            }
        }
        if (PluginProvider.class.isAssignableFrom(clazz)) {
            PluginProvider pp = (PluginProvider)clazz.newInstance();
            return pp.create(ucl);
        }
        throw new IllegalArgumentException("Cannot create plugin from " + provider);
    }

    protected static void store(File directory, Map<ScanningPlugin, ScanningHandle> handles) throws Exception {
        if (handles == null) {
            throw new IllegalArgumentException("Null handles");
        }
        if (directory == null) {
            throw new IllegalArgumentException("Directory is null");
        }
        if (!directory.exists() && !directory.mkdir()) {
            throw new IllegalArgumentException("Cannot create directory: " + directory);
        }
        for (Map.Entry<ScanningPlugin, ScanningHandle> entry : handles.entrySet()) {
            ScanningPlugin plugin = entry.getKey();
            File file = new File(directory, plugin.getFileName());
            FileOutputStream fos = new FileOutputStream(file);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            plugin.writeHandle((OutputStream)bos, entry.getValue());
        }
    }
}

