/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.scanning.indexer;

import java.io.File;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.scanning.indexer.Constants;
import org.jboss.scanning.indexer.core.ScanUtils;

public class Main {
    private static final Logger log = Logger.getLogger(Main.class.getName());

    private static void usage() {
        System.out.println("Usage: Indexer <input-jar> <scanning-plugins-comma-delimited> <classpath*>");
    }

    public static void main(String[] args) {
        try {
            int offset = 2;
            if (args.length < offset) {
                File input = new File(args[0]);
                String[] providers = args[1].split(",");
                URL[] urls = new URL[args.length - offset];
                for (int i = 0; i < urls.length; ++i) {
                    urls[i] = new File(args[i + offset]).toURI().toURL();
                }
                ScanUtils.scan(input, Constants.applyAliases(providers), urls);
            } else {
                Main.usage();
            }
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, t.getMessage(), t);
        }
    }
}

