/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.exception.example.basic.servlet.handler;

import java.io.IOException;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletResponse;
import org.jboss.seam.exception.control.CaughtException;
import org.jboss.seam.exception.control.Handles;
import org.jboss.seam.exception.control.HandlesExceptions;
import org.jboss.seam.exception.control.TraversalMode;
import org.jboss.seam.exception.example.basic.servlet.handler.HandlerOutput;

@HandlesExceptions
public class StandardHandlerDeclaration {
    final ResourceBundle messages = ResourceBundle.getBundle("org.jboss.seam.exception.example.basic.servlet.messages");

    public void throwableHandler(@Handles(during=TraversalMode.BREADTH_FIRST) CaughtException<Throwable> event, HttpServletResponse response) {
        HandlerOutput.printToResponse((ResourceBundle)this.messages, (Throwable)event.getException(), (HttpServletResponse)response, (String)"throwableHandler", (String)"markHandled");
        event.unmute();
        event.markHandled();
    }

    public void assertionErrorHandler(@Handles CaughtException<AssertionError> event, HttpServletResponse response) {
        HandlerOutput.printToResponse((ResourceBundle)this.messages, (Throwable)event.getException(), (HttpServletResponse)response, (String)"assertionErrorHandler", (String)"rethrow");
        event.rethrow();
    }

    public void nullPointerHandler(@Handles CaughtException<NullPointerException> event, HttpServletResponse response) {
        HandlerOutput.printToResponse((ResourceBundle)this.messages, (Throwable)event.getException(), (HttpServletResponse)response, (String)"nullPointerHandler", (String)"handled");
        event.handled();
    }

    public void illegalArgumenBreadthFirsttHandler(@Handles(during=TraversalMode.BREADTH_FIRST) CaughtException<IllegalArgumentException> event, HttpServletResponse response) {
        HandlerOutput.printToResponse((ResourceBundle)this.messages, (Throwable)event.getException(), (HttpServletResponse)response, (String)"illegalArgumentBreadthFirstHandler", (String)"dropCause");
        event.dropCause();
    }

    public void illegalArgumentHandler(@Handles CaughtException<IllegalArgumentException> event, HttpServletResponse response) {
        HandlerOutput.printToResponse((ResourceBundle)this.messages, (Throwable)event.getException(), (HttpServletResponse)response, (String)"illegalArgumentHandler", (String)"handled");
        event.handled();
    }

    public void illegalStateHandler(@Handles CaughtException<IllegalStateException> event, HttpServletResponse response) {
        HandlerOutput.printToResponse((ResourceBundle)this.messages, (Throwable)event.getException(), (HttpServletResponse)response, (String)"illegalStateHandler", (String)"abort");
        event.abort();
    }

    public void ioExceptionHandler(@Handles CaughtException<IOException> event, HttpServletResponse response) {
        HandlerOutput.printToResponse((ResourceBundle)this.messages, (Throwable)event.getException(), (HttpServletResponse)response, (String)"illegalStateHandler", (String)"rethrow(new ArithmeticException)");
        event.rethrow((Throwable)new ArithmeticException("Re-thrown"));
    }
}

