/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.exception.control.example.jaxrs.db;

import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.enterprise.event.Observes;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.servlet.ServletContext;
import org.jboss.seam.exception.control.example.jaxrs.entity.Author;
import org.jboss.seam.exception.control.example.jaxrs.entity.Book;
import org.jboss.seam.servlet.event.Destroyed;
import org.jboss.seam.servlet.event.Initialized;

@Stateless
public class InitDatabaseBean {
    @PersistenceContext
    private EntityManager em;

    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void seedDatabase(@Observes @Initialized ServletContext sc) {
        Author hal_fulton = this.createAuthor("Hal Fulton");
        Author max_katz = this.createAuthor("Max Katz");
        Author gavin_king = this.createAuthor("Gavin King");
        Author christian_bauer = this.createAuthor("Christian Bauer");
        Author dan_allen = this.createAuthor("Dan Allen");
        Book ruby_way = this.createBook("The Ruby Way");
        Book practical_richfaces = this.createBook("Practical RichFaces");
        Book java_persistence = this.createBook("Java Persistence with Hibernate");
        Book seam_in_action = this.createBook("Seam in Action");
        hal_fulton.addBook(ruby_way);
        ruby_way.addAuthor(hal_fulton);
        this.em.persist((Object)hal_fulton);
        this.em.persist((Object)ruby_way);
        max_katz.addBook(practical_richfaces);
        practical_richfaces.addAuthor(max_katz);
        this.em.persist((Object)max_katz);
        this.em.persist((Object)practical_richfaces);
        java_persistence.addAuthor(gavin_king);
        java_persistence.addAuthor(christian_bauer);
        gavin_king.addBook(java_persistence);
        christian_bauer.addBook(java_persistence);
        this.em.persist((Object)java_persistence);
        this.em.persist((Object)gavin_king);
        this.em.persist((Object)christian_bauer);
        seam_in_action.addAuthor(dan_allen);
        dan_allen.addBook(seam_in_action);
        this.em.persist((Object)dan_allen);
        this.em.persist((Object)seam_in_action);
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void clear(@Observes @Destroyed ServletContext sc) {
        this.em.createQuery("delete from Book").executeUpdate();
        this.em.createQuery("delete from Author").executeUpdate();
    }

    private Author createAuthor(String authorName) {
        Author a = new Author();
        a.setName(authorName);
        return a;
    }

    private Book createBook(String bookTitle) {
        Book b = new Book();
        b.setTitle(bookTitle);
        return b;
    }
}

