/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.exception.control.example.jaxrs.handler;

import java.util.List;
import javax.ws.rs.core.Response;
import org.jboss.seam.exception.control.CatchResource;
import org.jboss.seam.exception.control.CaughtException;
import org.jboss.seam.exception.control.ExceptionResponse;
import org.jboss.seam.exception.control.ExceptionStack;
import org.jboss.seam.exception.control.Handles;
import org.jboss.seam.exception.control.HandlesExceptions;
import org.jboss.seam.exception.control.TraversalPath;
import org.jboss.seam.exception.control.example.jaxrs.handler.RestExceptionResponse;
import org.jboss.seam.exception.control.example.jaxrs.handler.RestRequest;
import org.jboss.seam.rest.exceptions.ErrorMessageWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@HandlesExceptions
public class RestExceptionHandlers {
    public void logException(@Handles(during=TraversalPath.DESCENDING) @RestRequest CaughtException<Throwable> event) {
        ExceptionStack c = event.getExceptionStack();
        System.out.println("Caught exception (" + (c.getIndex() + 1) + " in stack of " + c.getCauseElements().size() + ") => " + event.getException().getClass().getSimpleName() + "(\"" + event.getException().getMessage() + "\") ");
    }

    public void configurableExceptionHandler(@Handles(precedence=-100) @RestRequest CaughtException<Throwable> event, @CatchResource Response.ResponseBuilder responseBuilder, @RestRequest List<ExceptionResponse> exceptionResponses) {
        Class<?> exceptionClass = event.getException().getClass();
        for (ExceptionResponse response : exceptionResponses) {
            if (!exceptionClass.equals(response.getForType())) continue;
            responseBuilder.status(((RestExceptionResponse)response).getStatusCode());
            if (response.getMessage() == null) break;
            responseBuilder.entity((Object)new ErrorMessageWrapper(response.getMessage()));
            break;
        }
    }
}

