/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.exception.filter;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.jboss.seam.exception.filter.StackFrame;

final class StackFrameImpl
implements StackFrame {
    private StackTraceElement stackTraceElement;
    private final Map<String, StackFrame> markMap;
    private final int index;

    StackFrameImpl(Throwable throwable) {
        this.index = 0;
        this.stackTraceElement = throwable.getStackTrace()[this.index];
        this.markMap = new HashMap<String, StackFrame>();
    }

    public StackFrameImpl(StackFrameImpl copy, StackTraceElement nextStackTraceElement, int traceIndex) {
        this.stackTraceElement = nextStackTraceElement;
        this.markMap = copy.markMap;
        this.index = traceIndex;
    }

    @Override
    public StackTraceElement getStackTraceElement() {
        return this.stackTraceElement;
    }

    @Override
    public void mark(String tag) {
        this.markMap.put(tag, this);
    }

    @Override
    public StackFrame getMarkedFrame(String tag) {
        return this.markMap.get(tag);
    }

    @Override
    public boolean isMarkSet(String tag) {
        return this.markMap.containsKey(tag);
    }

    @Override
    public void clearMark(String tag) {
        this.markMap.remove(tag);
    }

    @Override
    public void setStackTraceElement(StackTraceElement element) {
        this.stackTraceElement = element;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StackFrameImpl that = (StackFrameImpl)o;
        if (this.index != that.index) {
            return false;
        }
        if (!((Object)this.markMap).equals(that.markMap)) {
            return false;
        }
        return this.stackTraceElement.equals(that.stackTraceElement);
    }

    public int hashCode() {
        int result = this.stackTraceElement.hashCode();
        result = 31 * result + ((Object)this.markMap).hashCode();
        result = 31 * result + this.index;
        return result;
    }

    public String toString() {
        return MessageFormat.format("Element Index: {0}", this.index) + ", " + MessageFormat.format("element: {0}", this.stackTraceElement) + ", " + MessageFormat.format("tags: {0}", this.markMap.keySet());
    }
}

