/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.config.example.princessrescue;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.seam.config.example.princessrescue.GameMessage;
import org.jboss.seam.config.example.princessrescue.GameRoom;
import org.jboss.seam.config.example.princessrescue.RoomType;
import org.jboss.seam.config.example.princessrescue.ShootEffect;

@SessionScoped
@Named
public class GameManager
implements Serializable {
    Instance<GameRoom> allRooms;
    @Inject
    GameMessage gameMessage;
    GameRoom startRoom;
    GameRoom currentRoom;
    String emptyRoomShootMessage;
    String startMessage;
    boolean gameOver = true;

    public String newGame() {
        for (GameRoom i : this.allRooms) {
            i.reset();
        }
        this.gameMessage.add(this.startMessage);
        this.runRoom(this.startRoom);
        this.gameOver = false;
        return "play";
    }

    public void runRoom(GameRoom room) {
        this.currentRoom = room;
        if (this.currentRoom.isMonsterKilled()) {
            this.gameMessage.add(room.getKilledRoomMessage());
        } else {
            this.gameMessage.add(room.getMessage());
        }
        if (room.getRoomType() == RoomType.GAMEOVER) {
            this.gameOver = true;
        } else {
            for (GameRoom g : this.getAdjacentRooms()) {
                if (g.isMonsterKilled()) continue;
                this.gameMessage.add(g.getAdjacentMessage());
            }
        }
    }

    public void runShoot(GameRoom room) {
        if (room.getShootEffect() == ShootEffect.KILL) {
            room.setMonsterKilled(true);
        } else if (room.getShootEffect() == ShootEffect.ANNOY) {
            this.gameOver = true;
        }
        if (room.getShootMessage() != null) {
            this.gameMessage.add(room.getShootMessage());
        } else {
            this.gameMessage.add(this.emptyRoomShootMessage);
        }
    }

    private Set<GameRoom> getAdjacentRooms() {
        HashSet<GameRoom> ret = new HashSet<GameRoom>();
        if (this.currentRoom.getNorth() != null) {
            ret.add(this.currentRoom.getNorth());
        }
        if (this.currentRoom.getSouth() != null) {
            ret.add(this.currentRoom.getSouth());
        }
        if (this.currentRoom.getEast() != null) {
            ret.add(this.currentRoom.getEast());
        }
        if (this.currentRoom.getWest() != null) {
            ret.add(this.currentRoom.getWest());
        }
        return ret;
    }

    public void shootNorth() {
        if (this.currentRoom.getNorth() != null) {
            this.runShoot(this.currentRoom.getNorth());
        } else {
            this.gameMessage.add("You cannot shoot that way");
        }
    }

    public void shootSouth() {
        if (this.currentRoom.getSouth() != null) {
            this.runShoot(this.currentRoom.getSouth());
        } else {
            this.gameMessage.add("You cannot shoot that way");
        }
    }

    public void shootEast() {
        if (this.currentRoom.getEast() != null) {
            this.runShoot(this.currentRoom.getEast());
        } else {
            this.gameMessage.add("You cannot shoot that way");
        }
    }

    public void shootWest() {
        if (this.currentRoom.getWest() != null) {
            this.runShoot(this.currentRoom.getWest());
        } else {
            this.gameMessage.add("You cannot shoot that way");
        }
    }

    public void moveNorth() {
        if (this.currentRoom.getNorth() != null) {
            this.runRoom(this.currentRoom.getNorth());
        } else {
            this.gameMessage.add("You cannot move that way");
        }
    }

    public void moveSouth() {
        if (this.currentRoom.getSouth() != null) {
            this.runRoom(this.currentRoom.getSouth());
        } else {
            this.gameMessage.add("You cannot move that way");
        }
    }

    public void moveEast() {
        if (this.currentRoom.getEast() != null) {
            this.runRoom(this.currentRoom.getEast());
        } else {
            this.gameMessage.add("You cannot move that way");
        }
    }

    public void moveWest() {
        if (this.currentRoom.getWest() != null) {
            this.runRoom(this.currentRoom.getWest());
        } else {
            this.gameMessage.add("You cannot move that way");
        }
    }

    public GameRoom getCurrentRoom() {
        return this.currentRoom;
    }

    public void setCurrentRoom(GameRoom currentRoom) {
        this.currentRoom = currentRoom;
    }

    public boolean isGameOver() {
        return this.gameOver;
    }
}

