/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.reader;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;

public class CacheableMultiReader
extends MultiReader {
    final IndexReader[] subReaders;

    public CacheableMultiReader(IndexReader[] subReaders) throws IOException {
        super(subReaders);
        this.subReaders = subReaders;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CacheableMultiReader)) {
            return false;
        }
        CacheableMultiReader that = (CacheableMultiReader)((Object)obj);
        int length = this.subReaders.length;
        if (length != that.subReaders.length) {
            return false;
        }
        for (int index = 0; index < length; ++index) {
            if (this.subReaders[index].equals(that.subReaders[index])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        for (IndexReader reader : this.subReaders) {
            result = 31 * result + reader.hashCode();
        }
        return result;
    }
}

