/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.event;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.engine.EntityEntry;
import org.hibernate.event.AbstractCollectionEvent;
import org.hibernate.event.PostCollectionRecreateEvent;
import org.hibernate.event.PostCollectionRecreateEventListener;
import org.hibernate.event.PostCollectionRemoveEvent;
import org.hibernate.event.PostCollectionRemoveEventListener;
import org.hibernate.event.PostCollectionUpdateEvent;
import org.hibernate.event.PostCollectionUpdateEventListener;
import org.hibernate.search.backend.WorkType;
import org.hibernate.search.event.FullTextIndexEventListener;

public class FullTextIndexCollectionEventListener
extends FullTextIndexEventListener
implements PostCollectionRecreateEventListener,
PostCollectionRemoveEventListener,
PostCollectionUpdateEventListener {
    private static Log log = LogFactory.getLog(FullTextIndexCollectionEventListener.class);

    public void onPostRecreateCollection(PostCollectionRecreateEvent event) {
        this.processCollectionEvent(event);
    }

    private void processCollectionEvent(AbstractCollectionEvent event) {
        Object entity = event.getAffectedOwnerOrNull();
        if (entity == null) {
            return;
        }
        if (this.used && this.searchFactoryImplementor.getDocumentBuilders().containsKey(entity.getClass())) {
            Serializable id = this.getId(entity, event);
            if (id == null) {
                log.warn((Object)("Unable to reindex entity on collection change, id cannot be extracted: " + event.getAffectedOwnerEntityName()));
                return;
            }
            this.processWork(entity, id, WorkType.COLLECTION, event);
        }
    }

    private Serializable getId(Object entity, AbstractCollectionEvent event) {
        Serializable id = event.getAffectedOwnerIdOrNull();
        if (id == null) {
            EntityEntry entityEntry = event.getSession().getPersistenceContext().getEntry(entity);
            id = entityEntry == null ? null : entityEntry.getId();
        }
        return id;
    }

    public void onPostRemoveCollection(PostCollectionRemoveEvent event) {
        this.processCollectionEvent(event);
    }

    public void onPostUpdateCollection(PostCollectionUpdateEvent event) {
        this.processCollectionEvent(event);
    }
}

