/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.store;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.hibernate.HibernateException;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.util.DirectoryProviderHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSDirectoryProvider
implements DirectoryProvider<FSDirectory> {
    private static Log log = LogFactory.getLog(FSDirectoryProvider.class);
    private FSDirectory directory;
    private String indexName;

    @Override
    public void initialize(String directoryProviderName, Properties properties, SearchFactoryImplementor searchFactoryImplementor) {
        File indexDir = DirectoryProviderHelper.determineIndexDir(directoryProviderName, properties);
        try {
            boolean create;
            boolean bl = create = !indexDir.exists();
            if (create) {
                log.debug((Object)("index directory not found, creating: '" + indexDir.getAbsolutePath() + "'"));
                indexDir.mkdirs();
            }
            this.indexName = indexDir.getCanonicalPath();
            this.directory = FSDirectory.getDirectory((String)this.indexName);
            if (create) {
                log.debug((Object)("Initialize index: '" + this.indexName + "'"));
                IndexWriter iw = new IndexWriter((Directory)this.directory, (Analyzer)new StandardAnalyzer(), create);
                iw.close();
            }
        }
        catch (IOException e) {
            throw new HibernateException("Unable to initialize index: " + directoryProviderName, e);
        }
    }

    @Override
    public void start() {
    }

    @Override
    public FSDirectory getDirectory() {
        return this.directory;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof FSDirectoryProvider)) {
            return false;
        }
        return this.indexName.equals(((FSDirectoryProvider)obj).indexName);
    }

    public int hashCode() {
        int hash = 11;
        return 37 * hash + this.indexName.hashCode();
    }
}

