/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader;

import java.util.ArrayList;
import java.util.Map;
import org.hibernate.FetchMode;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.engine.CascadeStyle;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.loader.BasicLoader;
import org.hibernate.loader.JoinWalker;
import org.hibernate.loader.OuterJoinableAssociation;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.sql.JoinFragment;
import org.hibernate.sql.Select;
import org.hibernate.type.AssociationType;
import org.hibernate.util.CollectionHelper;

public abstract class AbstractEntityJoinWalker
extends JoinWalker {
    private final OuterJoinLoadable persister;
    private final String alias;

    public AbstractEntityJoinWalker(OuterJoinLoadable persister, SessionFactoryImplementor factory, Map enabledFilters) {
        this(persister, factory, enabledFilters, null);
    }

    public AbstractEntityJoinWalker(OuterJoinLoadable persister, SessionFactoryImplementor factory, Map enabledFilters, String alias) {
        super(factory, enabledFilters);
        this.persister = persister;
        this.alias = alias == null ? this.generateRootAlias(persister.getEntityName()) : alias;
    }

    protected final void initAll(String whereString, String orderByString, LockMode lockMode) throws MappingException {
        this.walkEntityTree(this.persister, this.getAlias());
        ArrayList<OuterJoinableAssociation> allAssociations = new ArrayList<OuterJoinableAssociation>();
        allAssociations.addAll(this.associations);
        allAssociations.add(new OuterJoinableAssociation(this.persister.getEntityType(), null, null, this.alias, 1, this.getFactory(), CollectionHelper.EMPTY_MAP));
        this.initPersisters(allAssociations, lockMode);
        this.initStatementString(whereString, orderByString, lockMode);
    }

    protected final void initProjection(String projectionString, String whereString, String orderByString, String groupByString, LockMode lockMode) throws MappingException {
        this.walkEntityTree(this.persister, this.getAlias());
        this.persisters = new Loadable[0];
        this.initStatementString(projectionString, whereString, orderByString, groupByString, lockMode);
    }

    private void initStatementString(String condition, String orderBy, LockMode lockMode) throws MappingException {
        this.initStatementString(null, condition, orderBy, "", lockMode);
    }

    private void initStatementString(String projection, String condition, String orderBy, String groupBy, LockMode lockMode) throws MappingException {
        int joins = AbstractEntityJoinWalker.countEntityPersisters(this.associations);
        this.suffixes = BasicLoader.generateSuffixes(joins + 1);
        JoinFragment ojf = this.mergeOuterJoins(this.associations);
        Select select = new Select(this.getDialect()).setLockMode(lockMode).setSelectClause(projection == null ? this.persister.selectFragment(this.alias, this.suffixes[joins]) + this.selectString(this.associations) : projection).setFromClause(this.getDialect().appendLockHint(lockMode, this.persister.fromTableFragment(this.alias)) + this.persister.fromJoinFragment(this.alias, true, true)).setWhereClause(condition).setOuterJoins(ojf.toFromFragmentString(), ojf.toWhereFragmentString() + this.getWhereFragment()).setOrderByClause(this.orderBy(this.associations, orderBy)).setGroupByClause(groupBy);
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            select.setComment(this.getComment());
        }
        this.sql = select.toStatementString();
    }

    protected String getWhereFragment() throws MappingException {
        return this.persister.whereJoinFragment(this.alias, true, true);
    }

    protected boolean isJoinedFetchEnabled(AssociationType type, FetchMode config, CascadeStyle cascadeStyle) {
        return this.isJoinedFetchEnabledInMapping(config, type);
    }

    public abstract String getComment();

    protected final Loadable getPersister() {
        return this.persister;
    }

    protected final String getAlias() {
        return this.alias;
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.getPersister().getEntityName() + ')';
    }
}

