/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine;

import java.util.Collections;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.search.engine.EntityInfo;
import org.hibernate.search.engine.Loader;
import org.hibernate.search.engine.ObjectLoaderHelper;
import org.hibernate.search.engine.SearchFactoryImplementor;

public class QueryLoader
implements Loader {
    private Session session;
    private Class entityType;
    private SearchFactoryImplementor searchFactoryImplementor;
    private Criteria criteria;
    private boolean isExplicitCriteria;

    public void init(Session session, SearchFactoryImplementor searchFactoryImplementor) {
        this.session = session;
        this.searchFactoryImplementor = searchFactoryImplementor;
    }

    public void setEntityType(Class entityType) {
        this.entityType = entityType;
    }

    public Object load(EntityInfo entityInfo) {
        if (this.isExplicitCriteria) {
            this.load(new EntityInfo[]{entityInfo});
        }
        return ObjectLoaderHelper.load(entityInfo, this.session);
    }

    public List load(EntityInfo ... entityInfos) {
        if (entityInfos.length == 0) {
            return Collections.EMPTY_LIST;
        }
        if (this.entityType == null) {
            throw new AssertionFailure("EntityType not defined");
        }
        if (this.criteria == null) {
            this.criteria = this.session.createCriteria(this.entityType);
        }
        ObjectLoaderHelper.initializeObjects(entityInfos, this.criteria, this.entityType, this.searchFactoryImplementor);
        return ObjectLoaderHelper.returnAlreadyLoadedObjectsInCorrectOrder(entityInfos, this.session);
    }

    public void setCriteria(Criteria criteria) {
        this.isExplicitCriteria = criteria != null;
        this.criteria = criteria;
    }
}

