/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.filter;

import java.io.IOException;
import java.util.BitSet;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.hibernate.search.util.LoggerFactory;
import org.hibernate.util.SoftLimitMRUCache;
import org.slf4j.Logger;

public class CachingWrapperFilter
extends Filter {
    private static final Logger log = LoggerFactory.make();
    public static final int DEFAULT_SIZE = 5;
    private final SoftLimitMRUCache cache;
    private final Filter filter;

    public CachingWrapperFilter(Filter filter) {
        this(filter, 5);
    }

    public CachingWrapperFilter(Filter filter, int size) {
        this.filter = filter;
        log.debug("Initialising SoftLimitMRUCache with hard ref size of {}", (Object)size);
        this.cache = new SoftLimitMRUCache(size);
    }

    public BitSet bits(IndexReader reader) throws IOException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        DocIdSet cached = (DocIdSet)this.cache.get(reader);
        if (cached != null) {
            return cached;
        }
        SoftLimitMRUCache softLimitMRUCache = this.cache;
        synchronized (softLimitMRUCache) {
            cached = (DocIdSet)this.cache.get(reader);
            if (cached != null) {
                return cached;
            }
            DocIdSet docIdSet = this.filter.getDocIdSet(reader);
            this.cache.put(reader, docIdSet);
            return docIdSet;
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + "(" + this.filter + ")";
    }

    public boolean equals(Object o) {
        if (!(o instanceof CachingWrapperFilter)) {
            return false;
        }
        return this.filter.equals(((CachingWrapperFilter)((Object)o)).filter);
    }

    public int hashCode() {
        return this.filter.hashCode() ^ 0x1117BF25;
    }
}

