/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.jbc2.entity;

import org.hibernate.cache.CacheDataDescription;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.EntityRegion;
import org.hibernate.cache.access.AccessType;
import org.hibernate.cache.access.EntityRegionAccessStrategy;
import org.hibernate.cache.jbc2.TransactionalDataRegionAdapter;
import org.hibernate.cache.jbc2.entity.OptimisticReadOnlyAccess;
import org.hibernate.cache.jbc2.entity.OptimisticTransactionalAccess;
import org.hibernate.cache.jbc2.entity.ReadOnlyAccess;
import org.hibernate.cache.jbc2.entity.TransactionalAccess;
import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityRegionImpl
extends TransactionalDataRegionAdapter
implements EntityRegion {
    public static final String TYPE = "ENTITY";
    private boolean optimistic;

    public EntityRegionImpl(Cache jbcCache, String regionName, String regionPrefix, CacheDataDescription metadata) {
        super(jbcCache, regionName, regionPrefix, metadata);
        this.optimistic = jbcCache.getConfiguration().getNodeLockingScheme() == Configuration.NodeLockingScheme.OPTIMISTIC;
    }

    @Override
    public EntityRegionAccessStrategy buildAccessStrategy(AccessType accessType) throws CacheException {
        if (AccessType.READ_ONLY.equals(accessType)) {
            return this.optimistic ? new OptimisticReadOnlyAccess(this) : new ReadOnlyAccess(this);
        }
        if (AccessType.TRANSACTIONAL.equals(accessType)) {
            return this.optimistic ? new OptimisticTransactionalAccess(this) : new TransactionalAccess(this);
        }
        throw new CacheException("unsupported access type [" + accessType.getName() + "]");
    }

    @Override
    protected Fqn<String> createRegionFqn(String regionName, String regionPrefix) {
        return EntityRegionImpl.getTypeLastRegionFqn(regionName, regionPrefix, TYPE);
    }
}

