/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.advice.annotation.assignability;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.jboss.aop.advice.annotation.assignability.AssignabilityAlgorithm;
import org.jboss.aop.advice.annotation.assignability.ChoiceBound;
import org.jboss.aop.advice.annotation.assignability.ParamTypeAssignabilityAlgorithm;
import org.jboss.aop.advice.annotation.assignability.VariableHierarchy;

class VariableNode {
    private VariableHierarchy hierarchy;
    private VariableNode previous;
    private VariableNode next;
    private Collection<Type> lowerBounds;
    private Collection<Type> upperBounds;
    private TypeVariable variable;
    private Type assignedValue;
    private static ParamTypeAssignabilityAlgorithm.EqualityChecker<VariableNode, ?> CHECKER = new ParamTypeAssignabilityAlgorithm.EqualityChecker<VariableNode, Object>(){

        @Override
        public boolean isSame(Type argument, Type fromArgument, VariableNode node, Object token) {
            return VariableNode.isSame(argument, fromArgument, false);
        }
    };

    public VariableNode(TypeVariable content, VariableHierarchy hierarchy) {
        this.hierarchy = hierarchy;
        this.variable = content;
        this.lowerBounds = new HashSet<Type>();
        this.upperBounds = new HashSet<Type>();
        Type[] bounds = content.getBounds();
        if (bounds.length == 1 && bounds[0] instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)bounds[0];
            this.next = hierarchy.getVariableNode(typeVariable);
            this.next.previous = this;
        }
    }

    public final boolean assignValue(Type value) {
        if (!this.isAssignabilityPermited(value)) {
            return false;
        }
        if (this.assignedValue != null) {
            return VariableNode.isSame(value, this.assignedValue, true);
        }
        if (!this.isInsideUpperBounds(value, false) || !this.areLowerBoundsInside(value, false)) {
            return false;
        }
        this.assignedValue = value;
        return true;
    }

    public final boolean addLowerBound(Type lowerBound) {
        if (!this.isInsideUpperBounds(lowerBound, false) || this.previous != null && !this.previous.areLowerBoundsInside(lowerBound, true)) {
            return false;
        }
        if (lowerBound instanceof TypeVariable) {
            Type[] bounds = ((TypeVariable)lowerBound).getBounds();
            this.lowerBounds.add(new ChoiceBound((TypeVariable)lowerBound, bounds));
        } else {
            this.lowerBounds.add(lowerBound);
        }
        return true;
    }

    public final boolean addUpperBound(Type upperBound) {
        if (this.next != null && !this.next.isInsideUpperBounds(upperBound, true) || !this.areLowerBoundsInside(upperBound, false)) {
            return false;
        }
        this.addToUpperBounds(upperBound);
        return true;
    }

    private void addToUpperBounds(Type upperBound) {
        if (upperBound instanceof TypeVariable) {
            Type[] bounds = ((TypeVariable)upperBound).getBounds();
            this.upperBounds.add(new ChoiceBound((TypeVariable)upperBound, bounds));
        } else {
            this.upperBounds.add(upperBound);
        }
    }

    public final boolean addMaximumUpperBound(Type upperBound) {
        if (!this.isAssignabilityPermited(upperBound)) {
            return false;
        }
        for (Type oldUpperBound : this.upperBounds) {
            if (VariableNode.isAssignable(upperBound, oldUpperBound)) continue;
            return false;
        }
        for (Type oldLowerBound : this.lowerBounds) {
            if (VariableNode.isAssignable(upperBound, oldLowerBound)) continue;
            return false;
        }
        if (this.assignedValue != null && !VariableNode.isAssignable(upperBound, this.assignedValue)) {
            return false;
        }
        if (this.next != null) {
            return this.next.addMaximumUpperBound(upperBound);
        }
        Type[] bounds = this.variable.getBounds();
        if (bounds.length == 1 && bounds[0] == Object.class) {
            return true;
        }
        for (Type bound : bounds) {
            if (VariableNode.isAssignable(upperBound, bound)) continue;
            return false;
        }
        return true;
    }

    private boolean isAssignabilityPermited(Type value) {
        return !(this.hierarchy.isBoundComparation() && !(value instanceof Class) && !(value instanceof ParameterizedType) || this.hierarchy.isRealBoundComparation() && value instanceof WildcardType);
    }

    private boolean areLowerBoundsInside(Type bound, boolean checkUpperBounds) {
        if (this.assignedValue != null && !VariableNode.isAssignable(bound, this.assignedValue)) {
            return false;
        }
        if (checkUpperBounds) {
            for (Type upperBound : this.upperBounds) {
                if (VariableNode.isAssignable(bound, upperBound)) continue;
                return false;
            }
        }
        for (Type lowerBound : this.lowerBounds) {
            if (VariableNode.isAssignable(bound, lowerBound)) continue;
            return false;
        }
        if (this.previous != null) {
            return this.previous.areLowerBoundsInside(bound, true);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isInsideUpperBounds(Type lowerBound, boolean checkLowerBounds) {
        if (this.assignedValue != null && !VariableNode.isAssignable(lowerBound, this.assignedValue)) {
            return false;
        }
        if (checkLowerBounds) {
            for (Type bound : this.lowerBounds) {
                if (VariableNode.isAssignable(bound, lowerBound)) continue;
                return false;
            }
        }
        for (Type upperBound : this.upperBounds) {
            if (VariableNode.isAssignable(upperBound, lowerBound)) continue;
            return false;
        }
        if (this.next == null) {
            Type[] bounds = this.variable.getBounds();
            this.hierarchy.startBoundComparation();
            try {
                for (int i = 0; i < bounds.length; ++i) {
                    if (AssignabilityAlgorithm.VARIABLE_TARGET.isAssignable(bounds[i], lowerBound, this.hierarchy)) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.hierarchy.finishBoundComparation();
            }
            return true;
        }
        return this.next.isInsideUpperBounds(lowerBound, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isSame(Type argument, Type fromArgument, boolean argumentAssigned) {
        if (argument instanceof WildcardType) {
            WildcardType wildcard = (WildcardType)argument;
            Type[] upperBounds = wildcard.getUpperBounds();
            Type[] lowerBounds = wildcard.getLowerBounds();
            if (fromArgument instanceof WildcardType) {
                WildcardType fromWildcard = (WildcardType)fromArgument;
                Type[] fromUpperBounds = fromWildcard.getUpperBounds();
                if (!VariableNode.isAssignable(upperBounds, fromUpperBounds)) {
                    return false;
                }
                Type[] fromLowerBounds = fromWildcard.getLowerBounds();
                block0: for (int i = 0; i < fromLowerBounds.length; ++i) {
                    for (int j = 0; j < lowerBounds.length; ++j) {
                        if (VariableNode.isAssignable(fromLowerBounds[i], lowerBounds[j])) continue block0;
                    }
                    return false;
                }
                return true;
            }
            if (argumentAssigned) {
                return false;
            }
            if (fromArgument instanceof TypeVariable) {
                if (VariableNode.isAssignable(upperBounds, ((TypeVariable)fromArgument).getBounds())) return argument.equals(fromArgument);
                return false;
            }
            for (int i = 0; i < upperBounds.length; ++i) {
                if (VariableNode.isAssignable(upperBounds[i], fromArgument)) continue;
                return false;
            }
            return true;
        }
        if (!(argument instanceof GenericArrayType)) return argument.equals(fromArgument);
        if (!(fromArgument instanceof GenericArrayType)) return false;
        return VariableNode.isSame(((GenericArrayType)argument).getGenericComponentType(), ((GenericArrayType)fromArgument).getGenericComponentType(), argumentAssigned);
    }

    private static boolean isAssignable(Type[] upperBounds, Type[] fromUpperBounds) {
        block0: for (int i = 0; i < upperBounds.length; ++i) {
            for (int j = 0; j < fromUpperBounds.length; ++j) {
                if (VariableNode.isAssignable(upperBounds[i], fromUpperBounds[j])) continue block0;
            }
            return false;
        }
        return true;
    }

    private static boolean isAssignable(Type type, Type fromType) {
        if (fromType instanceof TypeVariable) {
            Type[] fromBounds;
            TypeVariable fromVariable = (TypeVariable)fromType;
            if (type instanceof TypeVariable) {
                if (type == fromType) {
                    return true;
                }
                Type[] fromBounds2 = fromVariable.getBounds();
                while (fromBounds2.length == 1 && fromBounds2[0] instanceof TypeVariable) {
                    if (fromBounds2[0] == type) {
                        return true;
                    }
                    fromVariable = (TypeVariable)fromBounds2[0];
                    fromBounds2 = fromVariable.getBounds();
                }
                return false;
            }
            for (Type fromBound : fromBounds = AssignabilityAlgorithm.getConcreteBounds(fromVariable)) {
                if (!VariableNode.isAssignable(type, fromBound)) continue;
                return true;
            }
            return false;
        }
        if (fromType instanceof ChoiceBound) {
            ChoiceBound fromChoiceBound = (ChoiceBound)fromType;
            if (type instanceof TypeVariable && !VariableNode.isAssignable((TypeVariable)type, fromChoiceBound.variable)) {
                return false;
            }
            Iterator<Type> it = fromChoiceBound.bounds.iterator();
            while (it.hasNext()) {
                Type fromOption = it.next();
                if (VariableNode.isAssignable(type, fromOption)) continue;
                it.remove();
            }
            return !fromChoiceBound.bounds.isEmpty();
        }
        if (type instanceof Class) {
            if (type == Object.class) {
                return true;
            }
            Class clazz = (Class)type;
            if (fromType instanceof Class) {
                return clazz.isAssignableFrom((Class)fromType);
            }
            if (fromType instanceof ParameterizedType) {
                return clazz.isAssignableFrom((Class)((ParameterizedType)fromType).getRawType());
            }
            if (fromType instanceof WildcardType) {
                WildcardType fromWildcard = (WildcardType)fromType;
                boolean boundOk = false;
                for (Type upperBound : fromWildcard.getUpperBounds()) {
                    if (!VariableNode.isAssignable(type, upperBound)) continue;
                    boundOk = true;
                    break;
                }
                if (!boundOk) {
                    return false;
                }
                for (Type lowerBound : fromWildcard.getLowerBounds()) {
                    if (!VariableNode.isAssignable(type, lowerBound)) continue;
                    return true;
                }
                return false;
            }
            if (fromType instanceof TypeVariable) {
                for (Type upperBound : ((TypeVariable)fromType).getBounds()) {
                    if (!VariableNode.isAssignable(type, upperBound)) continue;
                    return true;
                }
                return false;
            }
            return clazz.isArray() && VariableNode.isAssignable(clazz.getComponentType(), ((GenericArrayType)fromType).getGenericComponentType());
        }
        if (type instanceof ParameterizedType) {
            return ParamTypeAssignabilityAlgorithm.isAssignable((ParameterizedType)type, fromType, CHECKER, null, null);
        }
        if (type instanceof TypeVariable) {
            for (Type bound : ((TypeVariable)type).getBounds()) {
                if (VariableNode.isAssignable(bound, fromType)) continue;
                return false;
            }
            return true;
        }
        if (type instanceof WildcardType) {
            WildcardType wildcard = (WildcardType)type;
            for (Type bound : wildcard.getUpperBounds()) {
                if (VariableNode.isAssignable(bound, fromType)) continue;
                return false;
            }
            for (Type bound : wildcard.getLowerBounds()) {
                if (VariableNode.isAssignable(bound, fromType)) continue;
                return false;
            }
            return true;
        }
        ChoiceBound choiceBound = (ChoiceBound)type;
        if (fromType instanceof TypeVariable && !VariableNode.isAssignable(choiceBound.variable, (TypeVariable)fromType)) {
            return false;
        }
        Iterator<Type> it = choiceBound.bounds.iterator();
        while (it.hasNext()) {
            Type boundOption = it.next();
            if (VariableNode.isAssignable(boundOption, fromType)) continue;
            it.remove();
        }
        return !choiceBound.bounds.isEmpty();
    }
}

