/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.impl;

import org.jboss.jms.delegate.IDBlock;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.contract.MessagingComponent;
import org.jboss.messaging.core.contract.PersistenceManager;

public class IDManager
implements MessagingComponent {
    private static final Logger log = Logger.getLogger(IDManager.class);
    private boolean trace = log.isTraceEnabled();
    private boolean started;
    private String counterName;
    private int bigBlockSize;
    private long high;
    private long low;
    private PersistenceManager pm;

    public IDManager(String counterName, int bigBlockSize, PersistenceManager pm) throws Exception {
        this.counterName = counterName;
        this.bigBlockSize = bigBlockSize;
        this.pm = pm;
    }

    public synchronized void start() throws Exception {
        this.getNextBigBlock();
        this.started = true;
    }

    public synchronized void stop() throws Exception {
        this.started = false;
    }

    protected void getNextBigBlock() throws Exception {
        this.low = this.pm.reserveIDBlock(this.counterName, this.bigBlockSize);
        this.high = this.low + (long)this.bigBlockSize - 1L;
        if (this.trace) {
            log.trace(this + " retrieved next block of size " + this.bigBlockSize + " from PersistenceManager, starting at " + this.low);
        }
    }

    public synchronized IDBlock getIDBlock(int size) throws Exception {
        if (!this.started) {
            throw new IllegalStateException(this + " is not started");
        }
        if (size <= 0) {
            throw new IllegalArgumentException("block size must be > 0");
        }
        if (size > this.bigBlockSize) {
            throw new IllegalArgumentException("block size must be <= bigBlockSize");
        }
        if ((long)size > this.high - this.low + 1L) {
            this.getNextBigBlock();
        }
        long low = this.low;
        this.low += (long)size;
        return new IDBlock(low, this.low - 1L);
    }

    public synchronized long getID() throws Exception {
        return this.getIDBlock(1).getLow();
    }

    public String toString() {
        return "IDManager[" + this.counterName + ", " + this.low + "-" + this.high + "]";
    }
}

