/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.standardmbean;

import java.lang.reflect.Method;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.ReflectionException;
import org.jboss.logging.Logger;
import org.jboss.mx.loading.LoaderRepository;
import org.jboss.mx.metadata.StandardMetaData;
import org.jboss.mx.server.ExceptionHandler;
import org.jboss.mx.standardmbean.StandardMBeanDelegate;

public class StandardMBeanImpl
implements StandardMBeanDelegate {
    private static final Logger log = Logger.getLogger(StandardMBeanImpl.class);
    private Object implementation;
    private Class mbeanInterface;
    private MBeanInfo cachedMBeanInfo;

    public StandardMBeanImpl(Object implementation, Class mbeanInterface) throws NotCompliantMBeanException {
        this.implementation = implementation;
        this.mbeanInterface = mbeanInterface;
    }

    protected StandardMBeanImpl(Class mbeanInterface) throws NotCompliantMBeanException {
        this.implementation = this;
        this.mbeanInterface = mbeanInterface;
    }

    public Object getImplementation() {
        return this.implementation;
    }

    public void setImplementation(Object implementation) throws NotCompliantMBeanException {
        if (implementation == null) {
            throw new IllegalArgumentException("Null implementation");
        }
        this.implementation = implementation;
    }

    public Class getImplementationClass() {
        return this.implementation.getClass();
    }

    public final Class getMBeanInterface() {
        return this.mbeanInterface;
    }

    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        try {
            Method method = this.implementation.getClass().getMethod("get" + attribute, null);
            return method.invoke(this.implementation, new Object[0]);
        }
        catch (Exception e) {
            JMException result = ExceptionHandler.handleException(e);
            if (result instanceof AttributeNotFoundException) {
                throw (AttributeNotFoundException)result;
            }
            if (result instanceof MBeanException) {
                throw (MBeanException)result;
            }
            if (result instanceof ReflectionException) {
                throw (ReflectionException)result;
            }
            throw new MBeanException(e, "Cannot get attribute: " + attribute);
        }
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        try {
            Class[] clArr = null;
            if (attribute.getValue() != null) {
                clArr = new Class[]{attribute.getValue().getClass()};
            }
            Method method = this.implementation.getClass().getMethod("set" + attribute.getName(), clArr);
            method.invoke(this.implementation, attribute.getValue());
        }
        catch (Exception e) {
            JMException result = ExceptionHandler.handleException(e);
            if (result instanceof AttributeNotFoundException) {
                throw (AttributeNotFoundException)result;
            }
            if (result instanceof InvalidAttributeValueException) {
                throw (InvalidAttributeValueException)result;
            }
            if (result instanceof MBeanException) {
                throw (MBeanException)result;
            }
            if (result instanceof ReflectionException) {
                throw (ReflectionException)result;
            }
            throw new MBeanException(e, "Cannot set attribute: " + attribute);
        }
    }

    public AttributeList getAttributes(String[] attributes) {
        try {
            AttributeList attrList = new AttributeList(attributes.length);
            for (int i = 0; i < attributes.length; ++i) {
                String name = attributes[i];
                Object value = this.getAttribute(name);
                attrList.add(new Attribute(name, value));
            }
            return attrList;
        }
        catch (Exception e) {
            JMException result = ExceptionHandler.handleException(e);
            throw new RuntimeException("Cannot get attributes", result);
        }
    }

    public AttributeList setAttributes(AttributeList attributes) {
        try {
            AttributeList attrList = new AttributeList(attributes.size());
            for (Attribute attr : attributes) {
                this.setAttribute(attr);
                String name = attr.getName();
                Object value = this.getAttribute(name);
                attrList.add(new Attribute(name, value));
            }
            return attrList;
        }
        catch (Exception e) {
            JMException result = ExceptionHandler.handleException(e);
            throw new RuntimeException("Cannot set attributes", result);
        }
    }

    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        try {
            Class[] sigcl = new Class[signature.length];
            for (int i = 0; i < signature.length; ++i) {
                sigcl[i] = this.loadClass(signature[i]);
            }
            Method method = this.implementation.getClass().getMethod(actionName, sigcl);
            return method.invoke(this.implementation, params);
        }
        catch (Exception e) {
            JMException result = ExceptionHandler.handleException(e);
            if (result instanceof MBeanException) {
                throw (MBeanException)result;
            }
            if (result instanceof ReflectionException) {
                throw (ReflectionException)result;
            }
            throw new MBeanException(e, "Cannot invoke: " + actionName);
        }
    }

    private Class loadClass(String className) throws ClassNotFoundException {
        Class<?> clazz = LoaderRepository.getNativeClassForName(className);
        if (clazz == null) {
            ClassLoader cl = this.getClass().getClassLoader();
            clazz = cl.loadClass(className);
        }
        return clazz;
    }

    public MBeanInfo getMBeanInfo() {
        MBeanInfo info = this.getCachedMBeanInfo();
        if (info == null) {
            try {
                info = this.buildMBeanInfo();
                this.cacheMBeanInfo(info);
            }
            catch (NotCompliantMBeanException e) {
                log.error("Unexcepted exception", e);
                throw new IllegalStateException("Unexcepted exception " + e.toString());
            }
        }
        return info;
    }

    public MBeanInfo getCachedMBeanInfo() {
        return this.cachedMBeanInfo;
    }

    public void cacheMBeanInfo(MBeanInfo info) {
        this.cachedMBeanInfo = info;
    }

    public MBeanInfo buildMBeanInfo() throws NotCompliantMBeanException {
        if (this.implementation == null) {
            throw new IllegalArgumentException("Null implementation");
        }
        StandardMetaData metaData = new StandardMetaData(this.implementation, this.mbeanInterface);
        this.mbeanInterface = metaData.getMBeanInterface();
        return metaData.build();
    }
}

