/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.filterfactory;

import java.util.Set;
import java.util.Vector;
import javax.management.Notification;
import javax.management.NotificationFilter;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.mx.util.JBossNotificationFilterSupport;
import org.jboss.system.NotificationFilterFactory;
import org.jboss.util.collection.CollectionsFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DeploymentInfoNotificationFilterFactory
implements NotificationFilterFactory {
    public static final String ENABLE_ELEMENT = "enable";
    public static final String ENABLE_TYPE_ATTRIBUTE = "type";
    public static final String ENABLE_SHORTNAME_ATTRIBUTE = "short-name";

    public NotificationFilter createNotificationFilter(Element filterConfig) throws Exception {
        DeploymentInfoNotificationFilter filter = new DeploymentInfoNotificationFilter();
        NodeList filterChildren = filterConfig.getChildNodes();
        for (int i = 0; i < filterChildren.getLength(); ++i) {
            Node filterChildNode = filterChildren.item(i);
            if (!filterChildNode.getNodeName().equals(ENABLE_ELEMENT)) continue;
            if (((Element)filterChildNode).hasAttribute(ENABLE_TYPE_ATTRIBUTE)) {
                String type = ((Element)filterChildNode).getAttribute(ENABLE_TYPE_ATTRIBUTE);
                filter.enableType(type);
                continue;
            }
            if (((Element)filterChildNode).hasAttribute(ENABLE_SHORTNAME_ATTRIBUTE)) {
                String shortName = ((Element)filterChildNode).getAttribute(ENABLE_SHORTNAME_ATTRIBUTE);
                filter.enableShortName(shortName);
                continue;
            }
            throw new Exception("'enable' element must have a 'type' or a 'short-name' attribute");
        }
        return filter;
    }

    public static class DeploymentInfoNotificationFilter
    extends JBossNotificationFilterSupport {
        private static final long serialVersionUID = -5067618040005609685L;
        private Set enabledShortNames = CollectionsFactory.createCopyOnWriteSet();

        public void disableAllShortNames() {
            this.enabledShortNames.clear();
        }

        public void disableShortName(String name) {
            this.enabledShortNames.remove(name);
        }

        public void enableShortName(String name) throws IllegalArgumentException {
            if (name == null) {
                throw new IllegalArgumentException("null shortName");
            }
            this.enabledShortNames.add(name);
        }

        public Vector getEnabledShortNames() {
            return new Vector(this.enabledShortNames);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(100);
            sb.append(this.getClass().getName()).append(':');
            sb.append(" enabledTypes=").append(this.getEnabledTypes());
            sb.append(" enabledShortNames=").append(this.getEnabledShortNames());
            return sb.toString();
        }

        public boolean isNotificationEnabled(Notification notification) {
            if (!super.isNotificationEnabled(notification)) {
                return false;
            }
            DeploymentInfo di = (DeploymentInfo)notification.getUserData();
            String shortName = di.shortName;
            return this.enabledShortNames.contains(shortName);
        }
    }
}

