/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.pm;

import org.jboss.mx.persistence.AttributePersistenceManager;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.system.pm.AttributePersistenceServiceMBean;
import org.w3c.dom.Element;

public class AttributePersistenceService
extends ServiceMBeanSupport
implements AttributePersistenceServiceMBean {
    public static final String DEFAULT_APM = "org.jboss.system.pm.XMLAttributePersistenceManager";
    public static final boolean DEFAULT_DESTROY_APM_ON_STOP = false;
    private AttributePersistenceManager apm = null;
    private Element apmConfig = null;
    private String apmClass = "org.jboss.system.pm.XMLAttributePersistenceManager";
    private boolean apmDestroyOnStop = false;
    private String versionTag = null;

    public AttributePersistenceService() {
        super(AttributePersistenceService.class);
    }

    public String getVersionTag() {
        return this.versionTag;
    }

    public void setVersionTag(String versionTag) {
        this.checkNotStarted();
        this.versionTag = versionTag;
    }

    public String getAttributePersistenceManagerClass() {
        return this.apmClass;
    }

    public void setAttributePersistenceManagerClass(String apmClass) {
        this.checkNotStarted();
        this.apmClass = apmClass;
    }

    public Element getAttributePersistenceManagerConfig() {
        return this.apmConfig;
    }

    public void setAttributePersistenceManagerConfig(Element apmConfig) {
        this.checkNotStarted();
        this.apmConfig = apmConfig;
    }

    public boolean getApmDestroyOnServiceStop() {
        return this.apmDestroyOnStop;
    }

    public void setApmDestroyOnServiceStop(boolean apmDestroyOnStop) {
        this.checkNotStarted();
        this.apmDestroyOnStop = apmDestroyOnStop;
    }

    public void startService() throws Exception {
        this.apm = (AttributePersistenceManager)this.getServer().instantiate(this.apmClass);
        this.apm.create(this.versionTag, this.apmConfig);
    }

    public void stopService() {
        if (this.apmDestroyOnStop) {
            this.apm.destroy();
        }
        this.apm = null;
    }

    public AttributePersistenceManager apmCreate() {
        this.checkStarted();
        return this.apm;
    }

    public boolean apmExists(String id) throws Exception {
        this.checkStarted();
        return this.apm.exists(id);
    }

    public void apmRemove(String id) throws Exception {
        this.checkStarted();
        this.apm.remove(id);
    }

    public void apmRemoveAll() throws Exception {
        this.checkStarted();
        this.apm.removeAll();
    }

    public String[] apmListAll() throws Exception {
        this.checkStarted();
        return this.apm.listAll();
    }

    public String apmListAllAsString() throws Exception {
        this.checkStarted();
        StringBuffer sbuf = new StringBuffer(1024);
        String[] list2 = this.apm.listAll();
        for (int i = 0; i < list2.length; ++i) {
            sbuf.append(list2[i]).append("\n");
        }
        return sbuf.toString();
    }

    private void checkStarted() {
        int state = this.getState();
        if (state != 3) {
            throw new IllegalStateException("Cannot perform operations unless service is started");
        }
    }

    private void checkNotStarted() {
        int state = this.getState();
        if (state == 2 || state == 3) {
            throw new IllegalStateException("Cannot modify attributes while service is started");
        }
    }
}

