/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice;

import java.util.Collection;
import org.jboss.bootstrap.spi.Bootstrap;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.deployers.client.spi.IncompleteDeploymentException;
import org.jboss.deployers.client.spi.main.MainDeployer;
import org.jboss.deployers.plugins.main.MainDeployerImpl;
import org.jboss.deployers.structure.spi.DeploymentContext;
import org.jboss.deployers.vfs.spi.client.VFSDeployment;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.logging.Logger;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.profileservice.spi.Profile;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.ProfileService;
import org.jboss.system.server.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileServiceBootstrap
implements Bootstrap {
    private static final Logger log = Logger.getLogger(ProfileServiceBootstrap.class);
    protected String profileName = "default";
    protected MainDeployer mainDeployer;
    protected ProfileService profileService;
    protected Kernel kernel;

    public MainDeployer getMainDeployer() {
        return this.mainDeployer;
    }

    public ProfileService getProfileService() {
        return this.profileService;
    }

    public Kernel getKernel() {
        return this.kernel;
    }

    public void setKernel(Kernel kernel) {
        this.kernel = kernel;
    }

    @Override
    public void start(Server server) throws Exception {
        KernelController controller = this.kernel.getController();
        this.profileService = this.getBean(controller, "ProfileService", ProfileService.class);
        log.debug("Using ProfileService: " + this.profileService);
        this.mainDeployer = this.getBean(controller, "MainDeployer", MainDeployer.class);
        log.debug("Using MainDeployer: " + this.mainDeployer);
        this.mainDeployer.checkComplete();
        try {
            this.loadProfile(this.profileName);
        }
        catch (IncompleteDeploymentException e) {
            log.error("Failed to load profile: " + e.getMessage());
        }
        catch (Exception e) {
            log.error("Failed to load profile: ", e);
        }
        Profile profile = this.profileService.getActiveProfile();
        if (profile != null) {
            profile.enableModifiedDeploymentChecks(true);
        }
    }

    @Override
    public void shutdown(Server server) {
        try {
            this.mainDeployer.shutdown();
        }
        catch (Throwable t) {
            log.warn("Error shutting down the main deployer", t);
        }
    }

    protected <T> T getBean(KernelController controller, Object name, Class<T> expectedType) {
        ControllerContext context = controller.getInstalledContext(name);
        if (context == null) {
            throw new IllegalStateException("Context not installed: " + name);
        }
        Object result = context.getTarget();
        if (result == null) {
            throw new IllegalStateException("No target for " + name);
        }
        if (!expectedType.isInstance(result)) {
            throw new IllegalStateException(name + " expected " + expectedType.getName() + " was " + result.getClass().getName());
        }
        return expectedType.cast(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadProfile(String name) throws Exception {
        DeploymentContext ctx;
        MainDeployer deployer = this.getMainDeployer();
        if (deployer == null) {
            throw new NullPointerException("MainDeployer has not been set");
        }
        ProfileService ps = this.getProfileService();
        if (ps == null) {
            throw new NullPointerException("ProfileService has not been set");
        }
        ProfileKey key = new ProfileKey(name);
        Profile profile = ps.getProfile(key);
        VFSDeployment first = null;
        Collection<VFSDeployment> boostraps = profile.getDeployments(ManagedDeployment.DeploymentPhase.BOOTSTRAP);
        for (VFSDeployment d : boostraps) {
            deployer.addDeployment(d);
            if (first != null) continue;
            first = d;
        }
        deployer.process();
        deployer.checkComplete();
        Thread thread = Thread.currentThread();
        ClassLoader old = thread.getContextClassLoader();
        MainDeployerImpl hack = (MainDeployerImpl)deployer;
        ClassLoader cl = null;
        if (first != null && (ctx = hack.getDeploymentContext(first.getName())) != null) {
            cl = ctx.getClassLoader();
        }
        if (cl != null) {
            thread.setContextClassLoader(cl);
        }
        try {
            Collection<VFSDeployment> profileDeployers = profile.getDeployments(ManagedDeployment.DeploymentPhase.DEPLOYER);
            for (VFSDeployment d : profileDeployers) {
                deployer.addDeployment(d);
            }
            deployer.process();
            deployer.checkComplete();
            Collection<VFSDeployment> profileDeployments = profile.getDeployments(ManagedDeployment.DeploymentPhase.APPLICATION);
            for (VFSDeployment d : profileDeployments) {
                deployer.addDeployment(d);
            }
            deployer.process();
            deployer.checkComplete();
        }
        finally {
            thread.setContextClassLoader(old);
        }
    }
}

